/* Study Bridge Mobile Helpers (non‑breaking) */
(function(){
  function isMobile(){
    return window.matchMedia && window.matchMedia('(max-width: 820px)').matches;
  }

  function wrapTables(){
    if (!isMobile()) return;
    var tables = Array.prototype.slice.call(document.querySelectorAll('table'));
    tables.forEach(function(tbl){
      // skip layout tables (very small) and already wrapped
      if (tbl.closest('.sb-table-scroll')) return;
      // If table is inside a card already, wrapping is safe
      var wrap = document.createElement('div');
      wrap.className = 'sb-table-scroll';
      tbl.parentNode.insertBefore(wrap, tbl);
      wrap.appendChild(tbl);
    });
  }

  function enhanceInputs(){
    if (!isMobile()) return;
    // Add inputmode numeric where obvious
    var nums = document.querySelectorAll('input[name*="phone"],input[name*="mobile"],input[name*="cnic"],input[name*="amount"],input[name*="salary"],input[name*="qty"],input[name*="quantity"],input[name*="rate"],input[name*="price"]');
    nums.forEach(function(i){
      if (!i.getAttribute('inputmode')) i.setAttribute('inputmode','numeric');
    });
  }

  document.addEventListener('DOMContentLoaded', function(){
    wrapTables();
    enhanceInputs();
  });

  // If the user rotates screen, re-check
  window.addEventListener('resize', function(){
    wrapTables();
  });
})();
