<?php
require_once 'sb_session.php';
require_once 'db.php';

@date_default_timezone_set('Asia/Karachi');

// Only admin
if (empty($_SESSION['admin']) && empty($_SESSION['admin_id'])) {
  header("Location: login.php");
  exit();
}

// CSRF
if (empty($_SESSION['bk_csrf'])) {
  $_SESSION['bk_csrf'] = bin2hex(random_bytes(16));
}
$csrf = (string)$_SESSION['bk_csrf'];

function sb_sql_escape(mysqli $conn, $v): string {
  if ($v === null) return 'NULL';
  if (is_int($v) || is_float($v)) return (string)$v;
  return "'" . mysqli_real_escape_string($conn, (string)$v) . "'";
}

function sb_dump_database(mysqli $conn, string $dbName): string {
  $out = '';
  $out .= "-- Study Bridge Backup\n";
  $out .= "-- Database: {$dbName}\n";
  $out .= "-- Generated: " . date('Y-m-d H:i:s') . " (Asia/Karachi)\n\n";
  $out .= "SET SQL_MODE = 'NO_AUTO_VALUE_ON_ZERO';\n";
  $out .= "SET time_zone = '+05:00';\n";
  $out .= "START TRANSACTION;\n";
  $out .= "SET NAMES utf8mb4;\n\n";

  $tables = [];
  $qr = mysqli_query($conn, "SHOW TABLES");
  if ($qr) {
    while ($row = mysqli_fetch_row($qr)) {
      if (!empty($row[0])) $tables[] = $row[0];
    }
  }

  foreach ($tables as $t) {
    // Schema
    $cr = mysqli_query($conn, "SHOW CREATE TABLE `{$t}`");
    $create = '';
    if ($cr) {
      $r = mysqli_fetch_assoc($cr);
      if ($r) {
        $create = $r['Create Table'] ?? '';
      }
    }
    if ($create !== '') {
      $out .= "\n-- ----------------------------\n";
      $out .= "-- Table structure for `{$t}`\n";
      $out .= "-- ----------------------------\n";
      $out .= "DROP TABLE IF EXISTS `{$t}`;\n";
      $out .= $create . ";\n\n";
    }

    // Data
    $dr = mysqli_query($conn, "SELECT * FROM `{$t}`");
    if ($dr) {
      $fields = mysqli_fetch_fields($dr);
      $colNames = array_map(function($f){ return '`'.$f->name.'`'; }, $fields);
      $colList = implode(',', $colNames);

      $rowsWritten = 0;
      while ($row = mysqli_fetch_assoc($dr)) {
        $vals = [];
        foreach ($fields as $f) {
          $name = $f->name;
          $vals[] = sb_sql_escape($conn, $row[$name] ?? null);
        }
        $out .= "INSERT INTO `{$t}` ({$colList}) VALUES (" . implode(',', $vals) . ");\n";
        $rowsWritten++;
        // safety for super huge dumps: flush chunk by chunk
        if ($rowsWritten % 500 == 0) $out .= "\n";
      }
      if ($rowsWritten > 0) $out .= "\n";
    }
  }

  $out .= "COMMIT;\n";
  return $out;
}

$msg = '';
$err = '';

if (isset($_POST['download'])) {
  $posted = (string)($_POST['csrf'] ?? '');
  if (!hash_equals($csrf, $posted)) {
    $err = 'Security error. Refresh and try again.';
  } else {
    $dbName = (string)(mysqli_fetch_row(mysqli_query($conn, "SELECT DATABASE()"))[0] ?? 'database');
    $sql = sb_dump_database($conn, $dbName);

    $fname = 'study_bridge_backup_' . date('Ymd_His') . '.sql';
    header('Content-Type: application/sql; charset=utf-8');
    header('Content-Disposition: attachment; filename="'.$fname.'"');
    header('Content-Length: ' . strlen($sql));
    echo $sql;
    exit();
  }
}

// rotate csrf each view
$_SESSION['bk_csrf'] = bin2hex(random_bytes(16));
$csrf = (string)$_SESSION['bk_csrf'];
?>
<!DOCTYPE html>
<html>
<head>
  <title>Database Backup</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body{margin:0;font-family:Arial;background:#f4f6f9;}
    .container{max-width:700px;margin:30px auto;background:#fff;padding:20px;border-radius:10px;}
    .btn{display:inline-block;padding:10px 14px;border-radius:8px;border:none;background:#1976d2;color:#fff;cursor:pointer;font-weight:bold;}
    .note{margin:12px 0;color:#555;font-size:13px;line-height:1.6;}
    .ok{padding:10px;border-radius:8px;background:#e8f5e9;color:#1b5e20;margin:10px 0;}
    .err{padding:10px;border-radius:8px;background:#ffebee;color:#b71c1c;margin:10px 0;}
    a{color:#1976d2;text-decoration:none;font-weight:bold;}
  </style>

<link rel="stylesheet" href="assets/sb_mobile.css?v=20260128">
<script src="assets/sb_mobile.js?v=20260128" defer></script>
</head>
<body>
  <div class="container">
    <h2>🗄️ Database Backup</h2>

    <?php if($msg){echo '<div class="ok">'.htmlspecialchars($msg).'</div>'; } ?>
    <?php if($err){echo '<div class="err">'.htmlspecialchars($err).'</div>'; } ?>

    <div class="note">
      • Ye backup aapke database ka SQL export download karega.<br>
      • Is file ko safe jagah par rakhain (Google Drive / USB).<br>
      • Restore ke liye phpMyAdmin → Import use kar sakte hain.
    </div>

    <form method="post">
      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>">
      <button class="btn" type="submit" name="download" value="1">⬇️ Download SQL Backup</button>
    </form>

    <div class="note" style="margin-top:18px;">
      <a href="dashboard.php">← Back to Dashboard</a>
    </div>
  </div>
</body>
</html>
