<?php
require_once 'db.php';
require_once 'auth.php';

function sb_ensure_delete_log_table(mysqli $conn): void {
  // Create if not exists (safe)
  $sql = "CREATE TABLE IF NOT EXISTS deleted_records (
    id INT AUTO_INCREMENT PRIMARY KEY,
    table_name VARCHAR(64) NOT NULL,
    record_id INT NOT NULL,
    deleted_by INT NOT NULL,
    deleted_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    reason VARCHAR(255) DEFAULT NULL,
    snapshot_json LONGTEXT NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
  @mysqli_query($conn, $sql);
}

function sb_log_delete(mysqli $conn, string $table, int $record_id, int $deleted_by, array $snapshot, string $reason = ''): bool {
  sb_ensure_delete_log_table($conn);
  $json = json_encode($snapshot, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  if ($json === false) $json = '{}';

  $st = mysqli_prepare($conn, "INSERT INTO deleted_records (table_name, record_id, deleted_by, reason, snapshot_json) VALUES (?,?,?,?,?)");
  if (!$st) return false;
  mysqli_stmt_bind_param($st, "siiss", $table, $record_id, $deleted_by, $reason, $json);
  $ok = mysqli_stmt_execute($st);
  mysqli_stmt_close($st);
  return (bool)$ok;
}
