<?php
require_once 'sb_session.php';
require_once 'db.php';

@date_default_timezone_set('Asia/Karachi');

$msg = '';
$type = 'warn';

// CSRF
if (empty($_SESSION['fp_csrf'])) {
  $_SESSION['fp_csrf'] = bin2hex(random_bytes(16));
}
$csrf = (string)$_SESSION['fp_csrf'];

if (isset($_POST['reset'])) {
  $posted = (string)($_POST['csrf'] ?? '');
  if (!hash_equals($csrf, $posted)) {
    $msg = 'Security error. Please refresh.';
    $type = 'err';
  } else {
    $mobile = preg_replace('/\s+/', '', (string)($_POST['mobile'] ?? ''));
    $pw1 = (string)($_POST['pw1'] ?? '');
    $pw2 = (string)($_POST['pw2'] ?? '');

    if ($mobile === '' || $pw1 === '' || $pw2 === '') {
      $msg = 'Please fill all fields.';
      $type = 'warn';
    } elseif ($pw1 !== $pw2) {
      $msg = 'Passwords do not match.';
      $type = 'warn';
    } elseif (strlen($pw1) < 6) {
      $msg = 'Password must be at least 6 characters.';
      $type = 'warn';
    } else {
      // Find staff by mobile (linked to users)
      $row = null;
      $st = mysqli_prepare($conn, "SELECT id, user_id, name FROM staff_account WHERE mobile=? LIMIT 1");
      if ($st) {
        mysqli_stmt_bind_param($st, 's', $mobile);
        mysqli_stmt_execute($st);
        // mysqlnd-free fetch
mysqli_stmt_bind_result($st, $sid, $suser_id, $sname);
$row = null;
if (mysqli_stmt_fetch($st)) {
  $row = [
    'id' => (int)$sid,
    'user_id' => (int)$suser_id,
    'name' => (string)$sname
  ];
}

        mysqli_stmt_close($st);
      }

      if (!$row || empty($row['user_id'])) {
        $msg = 'Mobile not found or not linked with a user. Contact admin.';
        $type = 'err';
      } else {
        $uid = (int)$row['user_id'];
        $hash = password_hash($pw1, PASSWORD_DEFAULT);

        $up = mysqli_prepare($conn, "UPDATE users SET password=? WHERE id=? LIMIT 1");
        if ($up) {
          mysqli_stmt_bind_param($up, 'si', $hash, $uid);
          $ok = mysqli_stmt_execute($up);
          mysqli_stmt_close($up);
          if ($ok) {
            // Optional: also keep staff_account.password consistent (if someone used it earlier)
            $up2 = mysqli_prepare($conn, "UPDATE staff_account SET password=? WHERE id=? LIMIT 1");
            if ($up2) {
              $sid = (int)$row['id'];
              mysqli_stmt_bind_param($up2, 'si', $hash, $sid);
              @mysqli_stmt_execute($up2);
              mysqli_stmt_close($up2);
            }

            $msg = '✅ Password reset successfully. Now login.';
            $type = 'ok';
          } else {
            $msg = '❌ Reset failed. Try again.';
            $type = 'err';
          }
        } else {
          $msg = 'Server error. Try again.';
          $type = 'err';
        }
      }
    }

    // rotate csrf
    $_SESSION['fp_csrf'] = bin2hex(random_bytes(16));
    $csrf = (string)$_SESSION['fp_csrf'];
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>STUDY BRIDGE | Forgot Password</title>
  <style>
    :root{--bg:#f5f7fb;--card:#fff;--text:#0f172a;--muted:#475569;--pri:#2563eb;--pri2:#1d4ed8;--acc:#06b6d4;--stroke:rgba(15,23,42,.10);--shadow:0 14px 38px rgba(15,23,42,.10);--radius:18px;}
    *{box-sizing:border-box;}
    body{margin:0;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Arial,"Noto Sans",sans-serif;background:radial-gradient(900px 500px at 12% 8%, rgba(37,99,235,.18), transparent 60%),radial-gradient(900px 600px at 88% 22%, rgba(6,182,212,.16), transparent 60%),linear-gradient(180deg,#fff,var(--bg));color:var(--text);min-height:100vh;display:flex;align-items:center;justify-content:center;padding:18px;}
    .card{width:min(520px,96vw);background:rgba(255,255,255,.94);border:1px solid var(--stroke);border-radius:var(--radius);box-shadow:var(--shadow);padding:18px;}
    .brand{font-weight:1000;letter-spacing:.6px;font-size:22px;text-align:center;margin:0 0 6px;}
    .brand span{background:linear-gradient(90deg,var(--pri),var(--acc));-webkit-background-clip:text;background-clip:text;color:transparent;}
    .muted{text-align:center;color:var(--muted);font-size:12.5px;margin:0 0 14px;}
    label{display:block;font-weight:900;margin:10px 0 6px;}
    input{width:100%;padding:11px 12px;border-radius:12px;border:1px solid var(--stroke);background:#fff;outline:none;font-size:14px;}
    .btn{width:100%;padding:12px 12px;border-radius:14px;border:0;cursor:pointer;color:#fff;font-weight:1000;font-size:14px;background:linear-gradient(135deg,var(--pri),var(--pri2));box-shadow:0 12px 22px rgba(37,99,235,.22);margin-top:12px;}
    .btn:hover{filter:brightness(1.05)}
    .msg{padding:10px 12px;border-radius:12px;margin:0 0 12px;font-weight:900;font-size:13px;border:1px solid var(--stroke);background:#fff;color:var(--muted);}
    .msg.ok{border-color:rgba(22,163,74,.28);background:rgba(22,163,74,.08);color:#166534;}
    .msg.warn{border-color:rgba(245,158,11,.28);background:rgba(245,158,11,.10);color:#92400e;}
    .msg.err{border-color:rgba(239,68,68,.28);background:rgba(239,68,68,.10);color:#991b1b;}
    .links{display:flex;justify-content:space-between;gap:10px;flex-wrap:wrap;margin-top:12px;}
    .a{display:inline-flex;align-items:center;justify-content:center;padding:10px 12px;border-radius:12px;border:1px solid var(--stroke);background:#fff;color:var(--text);text-decoration:none;font-weight:900;box-shadow:0 10px 24px rgba(15,23,42,.08);}
  </style>

<link rel="stylesheet" href="assets/sb_mobile.css?v=20260128">
<script src="assets/sb_mobile.js?v=20260128" defer></script>
</head>
<body>
  <div class="card">
    <div class="brand"><span>STUDY BRIDGE</span></div>
    <div class="muted">Reset password using your mobile number</div>

    <?php if ($msg !== '') { ?>
      <div class="msg <?php echo htmlspecialchars($type); ?>"><?php echo htmlspecialchars($msg); ?></div>
    <?php } ?>

    <form method="post" autocomplete="off">
      <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>">

      <label>Mobile Number</label>
      <input name="mobile" placeholder="03xxxxxxxxx" required value="<?php echo htmlspecialchars((string)($_POST['mobile'] ?? '')); ?>">

      <label>New Password</label>
      <input type="password" name="pw1" required>

      <label>Confirm Password</label>
      <input type="password" name="pw2" required>

      <button class="btn" type="submit" name="reset">Reset Password</button>
    </form>

    <div class="links">
      <a class="a" href="login.php">⬅ Back to Login</a>
    </div>
  </div>
</body>
</html>
