<?php
require_once 'sb_session.php';

// LOGIN PROTECTION (admin dashboard pages)
// Accept both old and new keys.
if (empty($_SESSION['admin']) && empty($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

$displayUser = (string)($_SESSION['admin'] ?? $_SESSION['username'] ?? '');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Study Bridge | ERP</title>

<style>
*{box-sizing:border-box;}
body{
    margin:0;
    font-family:Arial, sans-serif;
    background:#f4f6f9;
}

/* TOP BAR */
.topbar{
    height:90px;
    background:#1976d2;
    color:#fff;
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:0 25px;
}
.company{font-size:26px;font-weight:bold;}
.user{text-align:right;font-size:13px;}
.user a{color:#fff;font-size:12px;text-decoration:none;}
.user a:hover{text-decoration:underline;}

/* UNDERLINE */
.underline{
    height:5px;
    background:linear-gradient(
        to right,
        #ffffff,
        rgba(255,0,0,.5),
        rgba(255,255,0,.5),
        rgba(255,192,203,.6)
    );
}

/* BACK BUTTON */
.back-bar{
    padding:8px 25px;
    background:#f4f6f9;
}
.back-btn{
    padding:7px 18px;
    background:#d32f2f;
    color:#fff;
    text-decoration:none;
    border-radius:20px;
    font-size:13px;
    font-weight:bold;
}
.back-btn:hover{background:#b71c1c;}
</style>

<link rel="stylesheet" href="assets/sb_mobile.css?v=20260128">
<script src="assets/sb_mobile.js?v=20260128" defer></script>
</head>

<body>

<div class="topbar">
    <div class="company">Study Bridge</div>
    <div class="user">
        <?php echo htmlspecialchars($displayUser); ?><br>
        <a href="logout.php">Logout</a>
    </div>
</div>

<div class="underline"></div>

<div class="back-bar">
    <a href="javascript:history.back()" class="back-btn">⬅ Back</a>
</div>
