<?php
require_once 'sb_session.php';
require_once 'db.php';
/* debug mode: login.php?debug=1 */
$DBG = (isset($_GET['debug']) && $_GET['debug'] === '1');
if ($DBG) { @ini_set('display_errors','1'); @error_reporting(E_ALL); }

/* Logout */
if (isset($_GET['logout']) && $_GET['logout'] == '1') {
  unset(
    $_SESSION['sb_user_id'], $_SESSION['sb_username'], $_SESSION['sb_role'],
    $_SESSION['user_id'], $_SESSION['username'], $_SESSION['role'],
    $_SESSION['admin_id'], $_SESSION['admin']
  );
  session_destroy();
  header("Location: login.php");
  exit();
}

$error = "";
$success = "";

/* helpers */
function ptc_safe($s){ return trim((string)$s); }
function ptc_is_hash($str){
  return (is_string($str) && strlen($str) > 20 && isset($str[0]) && $str[0] === '$');
}

/* already logged in */
if (!empty($_SESSION['sb_user_id']) || !empty($_SESSION['admin_id']) || !empty($_SESSION['user_id'])) {
  header("Location: dashboard.php");
  exit();
}

/* Handle change password (requires current password) */
if (isset($_POST['change_password'])) {

  $username = ptc_safe($_POST['cp_username'] ?? '');
  $oldpass  = ptc_safe($_POST['cp_old_password'] ?? '');
  $newpass  = ptc_safe($_POST['cp_new_password'] ?? '');
  $newpass2 = ptc_safe($_POST['cp_new_password2'] ?? '');

  if ($username === '' || $oldpass === '' || $newpass === '' || $newpass2 === '') {
    $error = "Please fill all password change fields";
  } else if ($newpass !== $newpass2) {
    $error = "New passwords do not match";
  } else if (strlen($newpass) < 4) {
    $error = "New password is too short";
  } else {

    $sql = "SELECT id, username, password, role
            FROM users
            WHERE username = ? AND status = 1
            LIMIT 1";

    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $uid, $uname, $storedPass, $role);

    if (mysqli_stmt_fetch($stmt)) {

      $ok = false;

      if (ptc_is_hash($storedPass)) {
        if (password_verify($oldpass, $storedPass)) $ok = true;
      } else if (strlen($storedPass) === 32 && ctype_xdigit($storedPass)) {
        if (hash_equals($storedPass, md5($oldpass))) $ok = true;
      } else {
        if (hash_equals($storedPass, $oldpass)) $ok = true;
      }

      if ($ok) {
        $newHash = password_hash($newpass, PASSWORD_DEFAULT);
        $up = mysqli_prepare($conn, "UPDATE users SET password=? WHERE id=? LIMIT 1");
        if ($up) {
          mysqli_stmt_bind_param($up, "si", $newHash, $uid);
          mysqli_stmt_execute($up);
          mysqli_stmt_close($up);
        }
        $success = "Password updated successfully. Please login.";
        $error = "";
      } else {
        $error = "Current password is wrong";
      }

    } else {
      $error = "User not found or inactive";
    }

    if ($stmt) mysqli_stmt_close($stmt);
  }
}

/* Handle login */
if (isset($_POST['login'])) {

  $username = ptc_safe($_POST['username'] ?? '');
  $password = ptc_safe($_POST['password'] ?? '');

  if ($username === '' || $password === '') {
    $error = "Please enter username and password";
  } else {

    $sql = "SELECT id, username, password, role
            FROM users
            WHERE username = ? AND status = 1
            LIMIT 1";

    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $uid, $uname, $storedPass, $role);

    if (mysqli_stmt_fetch($stmt)) {

      $ok = false;

      /* bcrypt password */
      if (ptc_is_hash($storedPass)) {

        if (password_verify($password, $storedPass)) {
          $ok = true;
        }

      }
      /* MD5 legacy password */
      else if (strlen($storedPass) === 32 && ctype_xdigit($storedPass)) {

        if (hash_equals($storedPass, md5($password))) {
          $ok = true;

          // auto upgrade MD5 → bcrypt
          $newHash = password_hash($password, PASSWORD_DEFAULT);
          $up = mysqli_prepare($conn, "UPDATE users SET password=? WHERE id=? LIMIT 1");
          if ($up) {
            mysqli_stmt_bind_param($up, "si", $newHash, $uid);
            mysqli_stmt_execute($up);
            mysqli_stmt_close($up);
          }
        }

      }
      /* plain text legacy password */
      else {

        if (hash_equals($storedPass, $password)) {
          $ok = true;

          // auto upgrade plain → bcrypt
          $newHash = password_hash($password, PASSWORD_DEFAULT);
          $up = mysqli_prepare($conn, "UPDATE users SET password=? WHERE id=? LIMIT 1");
          if ($up) {
            mysqli_stmt_bind_param($up, "si", $newHash, $uid);
            mysqli_stmt_execute($up);
            mysqli_stmt_close($up);
          }
        }
      }

      if ($ok) {

        session_regenerate_id(true);

        $_SESSION['sb_user_id']  = $uid;
        $_SESSION['sb_username'] = $uname;
        $_SESSION['sb_role']     = $role;

        // backward compatibility
        $_SESSION['user_id']  = $uid;
        $_SESSION['username'] = $uname;
        $_SESSION['role']     = $role;

        if ($role === 'admin') {
          $_SESSION['admin_id'] = $uid;
          $_SESSION['admin']    = $uname;
        }

        header("Location: dashboard.php");
        exit();

      } else {
        $error = "Invalid password";
      }

    } else {
      $error = "User not found or inactive";
    }

    mysqli_stmt_close($stmt);
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Study Bridge | Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
:root{
  --primary:#1F3C88;
  --primary-dark:#162E66;
  --bg:#F4F6F8;
  --text:#2C2C2C;
  --border:#D6D9DD;
  --danger:#E74C3C;

  /* Dark grey-blue outline */
  --outline: rgba(40, 62, 92, .78);
  --outline-soft: rgba(40, 62, 92, .38);

  /* Shared watercolor background (page + inner card + inputs) */
  --page-bg:
    radial-gradient(900px 500px at 20% 20%, rgba(127,185,255,.28), transparent 60%),
    radial-gradient(800px 450px at 80% 30%, rgba(191,227,255,.35), transparent 55%),
    radial-gradient(700px 400px at 40% 85%, rgba(200,205,215,.25), transparent 55%),
    var(--bg);
}

html,body{ height:100%; }
body{
  margin:0;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  background: var(--page-bg);
  font-family: "Segoe UI", "Trebuchet MS", Arial, Helvetica, sans-serif;
  color:var(--text);
}

.water-bg{
  background: var(--page-bg);
}

/* layout */
.wrap{
  width:min(900px, 96vw);
  display:flex;
  flex-direction:column;
  align-items:center;
  gap:18px;
}

.brand{
  text-align:center;
  margin-top:10px;
}
.top-title{
  font-size:40px;
  font-weight:900;
  letter-spacing:2.8px;
  text-transform:uppercase;
  color:transparent;
  background:linear-gradient(90deg, rgba(31,60,136,1), rgba(80,145,220,1), rgba(31,60,136,1));
  -webkit-background-clip:text;
  background-clip:text;
  text-shadow: 0 6px 18px rgba(31,60,136,.12);
}
.brand-underline{
  width:min(360px, 86vw);
  margin:10px auto 0;
  height:10px;
  position:relative;
}
.brand-underline:before,
.brand-underline:after{
  content:"";
  position:absolute;
  left:0; right:0;

  /* thinner double lines (about half of previous) */
  height:2px;
  border-radius:999px;

  /* watercolor shimmer */
  background:
    radial-gradient(14px 8px at 14% 50%, rgba(0,170,80,.35), transparent 72%),
    radial-gradient(14px 8px at 28% 50%, rgba(255,0,0,.30), transparent 72%),
    radial-gradient(16px 8px at 42% 50%, rgba(0,120,255,.30), transparent 72%),
    radial-gradient(16px 8px at 56% 50%, rgba(255,210,0,.28), transparent 72%),
    radial-gradient(16px 8px at 70% 50%, rgba(255,140,0,.28), transparent 72%),
    radial-gradient(16px 8px at 84% 50%, rgba(160,80,255,.28), transparent 72%),
    radial-gradient(14px 8px at 96% 50%, rgba(0,0,0,.22), transparent 72%),
    linear-gradient(90deg, rgba(127,185,255,.16), rgba(191,227,255,.22), rgba(127,185,255,.16));

  background-size:220% 100%;
  background-position:0% 50%;

  /* only moving colors (no grey outline) */
  box-shadow:none;
}
.brand-underline:before{
  top:1px;
  /* upper line should move to the RIGHT */
  animation: underlineRight 3.2s linear infinite;
}
.brand-underline:after{
  top:7px;
  opacity:1;
  /* lower line should move to the LEFT */
  animation: underlineLeft 3.2s linear infinite;
}

@keyframes underlineLeft{
  0%   { background-position:100% 50%; }
  100% { background-position:0% 50%; }
}
@keyframes underlineRight{
  0%   { background-position:0% 50%; }
  100% { background-position:100% 50%; }
}

/* PERFECT CIRCLE LOGIN ORB */
.orb{
  position:relative;
  width:clamp(420px, 72vmin, 560px);
  height:clamp(420px, 72vmin, 560px);
  border-radius:50%;
  display:flex;
  align-items:center;
  justify-content:center;
  overflow:hidden;

  /* static outer outline */
  border:3px solid var(--outline);
  box-shadow:
    0 18px 42px rgba(0,0,0,.16),
    0 0 0 10px rgba(255,255,255,.25),
    inset 0 0 0 1px rgba(255,255,255,.70);
}

/* OUTER ROTATING LIGHT (tyre-like) */
.orb::before{
  content:"";
  position:absolute;
  inset:-14px;
  border-radius:50%;
  pointer-events:none;

  /* a moving "light" + watercolor trail with BLACK included */
  background:
    conic-gradient(
      transparent 0deg 305deg,
      rgba(255,255,255,.95) 306deg 314deg,
      rgba(0,0,0,.90) 315deg 320deg,
      rgba(255, 0, 0, .85) 321deg 330deg,
      rgba(0, 170, 80, .85) 331deg 342deg,
      rgba(255, 214, 0, .85) 343deg 352deg,
      rgba(0, 120, 255, .85) 353deg 360deg
    );
  filter: blur(1.3px) saturate(1.2);
  opacity:.82;

  /* show as a thin ring only */
  -webkit-mask: radial-gradient(farthest-side, transparent calc(100% - 10px), #000 calc(100% - 9px), #000 100%);
          mask: radial-gradient(farthest-side, transparent calc(100% - 10px), #000 calc(100% - 9px), #000 100%);
  animation: spin 6.5s linear infinite;
}

/* INNER WATER-COLOR RING */
.orb::after{
  content:"";
  position:absolute;
  inset:14px;
  border-radius:50%;
  pointer-events:none;

  /* full watercolor circle: green red blue yellow orange purple red black */
  background:
    conic-gradient(
      rgba(0, 170, 80, .85),
      rgba(255, 0, 0, .85),
      rgba(0, 120, 255, .85),
      rgba(255, 214, 0, .85),
      rgba(255, 140, 0, .85),
      rgba(145, 70, 255, .85),
      rgba(255, 0, 0, .85),
      rgba(0,0,0,.92),
      rgba(0, 170, 80, .85)
    );
  filter: blur(1.2px) saturate(1.25);
  opacity:.62;

  -webkit-mask: radial-gradient(farthest-side, transparent calc(100% - 4px), #000 calc(100% - 3px), #000 100%);
          mask: radial-gradient(farthest-side, transparent calc(100% - 4px), #000 calc(100% - 3px), #000 100%);
  animation: spinReverse 12s linear infinite;
}

/* subtle grid + shimmer */
.orb-grid{
  position:absolute;
  inset:0;
  border-radius:50%;
  pointer-events:none;
  opacity:.11;
  background:
    repeating-radial-gradient(circle at center, rgba(40,62,92,.30) 0 1px, transparent 1px 14px),
    repeating-conic-gradient(from 0deg, rgba(40,62,92,.22) 0 8deg, transparent 8deg 20deg);
  filter: blur(.2px);
  animation: spin 22s linear infinite;
}

/* card inside the circle */
.login-card{
  position:relative;
  width:min(320px, 70%);
  border-radius:22px;
  padding:22px 22px 18px;
  box-shadow: 0 16px 34px rgba(0,0,0,.10);
  border:1.5px solid rgba(40, 62, 92, .55);
  backdrop-filter: blur(6px);
  -webkit-backdrop-filter: blur(6px);
}

label{
  display:block;
  font-weight:700;
  font-size:13px;
  margin:12px 0 6px;
  color:rgba(40, 62, 92, .92);
}

.input{
  width:100%;
  padding:12px 12px;
  font-size:14px;
  border-radius:14px;
  outline:none;
  border:1.6px solid rgba(40, 62, 92, .55); /* dark grey-blue */
  color:rgba(18, 25, 35, .95);
  box-sizing:border-box;
  background: var(--page-bg); /* same as page */
  box-shadow: inset 0 0 0 1px rgba(255,255,255,.45);
}
.input:focus{
  border-color: rgba(31,60,136,.75);
  box-shadow: 0 0 0 4px rgba(31,60,136,.14), inset 0 0 0 1px rgba(255,255,255,.55);
}

.pw-wrap{
  position:relative;
}
.eye{
  position:absolute;
  right:10px;
  top:50%;
  transform:translateY(-50%);
  border:0;
  background:transparent;
  font-size:18px;
  cursor:pointer;
  opacity:.75;
}
.eye:hover{ opacity:1; }

.submit{
  width:100%;
  margin-top:16px;
  padding:12px 12px;
  border-radius:14px;
  border:0;
  cursor:pointer;
  font-weight:800;
  letter-spacing:.4px;
  color:#fff;
  background: linear-gradient(90deg, var(--primary), rgba(80,145,220,1), var(--primary));
  box-shadow: 0 10px 20px rgba(31,60,136,.20);
}
.submit:hover{
  filter:brightness(1.02);
}

.error{
  margin-top:8px;
  padding:10px 12px;
  border-radius:14px;
  border:1px solid rgba(231,76,60,.45);
  background: rgba(231,76,60,.08);
  color: rgba(120,22,16,.92);
  font-size:13px;
}
.notice{
  margin-top:8px;
  padding:10px 12px;
  border-radius:14px;
  border:1px solid rgba(46,204,113,.42);
  background: rgba(46,204,113,.08);
  color: rgba(20,90,45,.92);
  font-size:13px;
}

/* bottom-right footer */
.page-footer{
  position:fixed;
  right:14px;
  bottom:10px;
  font-size:11px;
  color:rgba(40, 62, 92, .78);
  letter-spacing:.2px;
  user-select:none;
}
.page-footer b{
  font-weight:700;
}
@keyframes spin{ from{ transform:rotate(0deg);} to{ transform:rotate(360deg);} }
@keyframes spinReverse{ from{ transform:rotate(360deg);} to{ transform:rotate(0deg);} }

/* responsive */
@media (max-width:520px){
  .top-title{ font-size:32px; letter-spacing:2px; }
  .orb{ width: min(92vmin, 480px); height: min(92vmin, 480px); }
  .login-card{ width:min(300px, 78%); padding:18px; }
}

/* === Study Bridge Double Watercolor Underline (Thin + Opposite Directions) === */
.study-underline-wrap{
    position: relative;
    width: 220px;
    margin: 8px auto 18px;
    height: 10px;
}

.study-underline{
    position:absolute;
    left:0;
    width:100%;
    height:2px; /* thinner */
    border-radius:20px;
    background: linear-gradient(90deg,
        red, orange, yellow, green, cyan, blue, purple, black, red);
    background-size: 300% 100%;
}

.study-underline.top{
    top:0;
    animation: moveLeft 4s linear infinite;
}

.study-underline.bottom{
    bottom:0;
    animation: moveRight 4s linear infinite;
}

@keyframes moveLeft{
    0%{ background-position: 100% 0; }
    100%{ background-position: 0% 0; }
}

@keyframes moveRight{
    0%{ background-position: 0% 0; }
    100%{ background-position: 100% 0; }
}

</style>

<link rel="stylesheet" href="assets/sb_mobile.css?v=20260128">
<script src="assets/sb_mobile.js?v=20260128" defer></script>
</head>

<body>
  <div class="wrap">
    <div class="brand">
      <div class="top-title">Study Bridge</div>
      <div class="brand-underline"></div>
    </div>

    <div class="orb" aria-label="Login">
      <div class="orb-grid"></div>

      <div class="login-card water-bg">
        <?php if($success!=""){ ?>
          <div class="notice"><?php echo htmlspecialchars($success); ?></div>
        <?php } ?>

        <?php if($error!=""){ ?>
          <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php } ?>

        <form method="post" autocomplete="off">
          <label>Username</label>
          <input class="input" type="text" name="username" required>

          <label>Password</label>
          <div class="pw-wrap">
            <input class="input" id="pw" type="password" name="password" required>
            <button class="eye" type="button" id="togglePw" aria-label="Show/Hide Password">👁</button>
          </div>

          <button class="submit" type="submit" name="login">Login</button>
        </form>
      </div>
    </div>
  </div>

  <div class="page-footer"><b>Developed by Atika</b> | Mobile: <b>03127877558</b></div>

<script>
(function(){
  function toggleInput(id){
    var el=document.getElementById(id);
    if(!el) return;
    el.type = (el.type === 'password') ? 'text' : 'password';
  }

  var btn=document.getElementById('togglePw');
  if(btn){ btn.onclick=function(){ toggleInput('pw'); }; }

  document.addEventListener('click', function(e){
    var t = e.target;
    if(t && t.matches && t.matches('button.eye[data-eye]')){
      e.preventDefault();
      toggleInput(t.getAttribute('data-eye'));
    }
  });

  var b=document.getElementById('btnChangePw');
  var box=document.getElementById('changeBox');
  if(b && box){
    b.addEventListener('click', function(){
      box.classList.toggle('show');
      if(box.classList.contains('show')){
        var inp = box.querySelector('input');
        if(inp) inp.focus();
      }
    });
  }
})();
</script>
</body>
</html>
