<?php
/**
 * sb_session.php — Study Bridge dedicated PHP session
 * Prevents session collisions with other softwares on the same domain.
 *
 * Session name: SBSESSID
 * Cookie path: auto-detected from current install folder.
 *
 * NOTE:
 * If cookie path is wrong, session will not persist across pages and CSRF will fail.
 */

if (session_status() === PHP_SESSION_NONE) {
    $sessName = 'SBSESSID';
    if (session_name() !== $sessName) {
        @session_name($sessName);
    }

    // Detect install base path from current script
    $script = (string)($_SERVER['SCRIPT_NAME'] ?? '/');
    $base = str_replace('\\', '/', dirname($script));
    $base = rtrim($base, '/');
    $cookiePath = ($base === '' ? '/' : ($base . '/'));

    $secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
    $params = session_get_cookie_params();
    $domain = isset($params['domain']) ? (string)$params['domain'] : '';

    if (PHP_VERSION_ID >= 70300) {
        session_set_cookie_params([
            'lifetime' => 0,
            'path' => $cookiePath,
            'domain' => $domain,
            'secure' => $secure,
            'httponly' => true,
            'samesite' => 'Lax',
        ]);
    } else {
        session_set_cookie_params(0, $cookiePath, $domain, $secure, true);
    }

    session_start();
}
