<?php
require_once 'sb_session.php';
require_once 'auth.php';

// Always keep timezone consistent
@date_default_timezone_set('Asia/Karachi');

function sb_display_user(): string {
  $u = (string)($_SESSION['admin'] ?? $_SESSION['username'] ?? $_SESSION['sb_username'] ?? '');
  return $u !== '' ? $u : 'User';
}

function sb_page_header(string $title): void {
  require_login();
  $displayUser = sb_display_user();
  $role = (string)($_SESSION['role'] ?? $_SESSION['sb_role'] ?? 'staff');
  $brand = 'STUDY BRIDGE';
  $safeTitle = htmlspecialchars($title);
  $safeUser  = htmlspecialchars($displayUser);
  $safeRole  = htmlspecialchars(strtoupper($role));

  echo "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"UTF-8\">\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n<title>{$brand} | {$safeTitle}</title>\n";
  echo "<link rel=\"stylesheet\" href=\"assets/sb_mobile.css?v=20260128\">\n";
  echo "<script src=\"assets/sb_mobile.js?v=20260128\" defer></script>\n";
  echo "<style>\n";
  echo ":root{--bg:#f5f7fb;--card:#fff;--text:#0f172a;--muted:#475569;--pri:#2563eb;--pri2:#1d4ed8;--acc:#06b6d4;--stroke:rgba(15,23,42,.10);--shadow:0 14px 38px rgba(15,23,42,.10);--radius:18px;}\n";
  echo "*{box-sizing:border-box;}\nbody{margin:0;font-family:ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Arial,\"Noto Sans\",sans-serif;background:radial-gradient(900px 500px at 12% 8%, rgba(37,99,235,.18), transparent 60%),radial-gradient(900px 600px at 88% 22%, rgba(6,182,212,.16), transparent 60%),linear-gradient(180deg,#fff,var(--bg));color:var(--text);min-height:100vh;}\n";
  echo ".topbar{position:sticky;top:0;z-index:10;display:flex;align-items:center;justify-content:space-between;padding:14px 18px;background:rgba(255,255,255,.88);backdrop-filter:blur(10px);border-bottom:1px solid var(--stroke);}\n";
  echo ".left{display:flex;align-items:center;gap:10px;min-width:180px;}\n";
  echo ".btn{display:inline-flex;align-items:center;justify-content:center;padding:9px 12px;border-radius:12px;text-decoration:none;font-weight:900;border:1px solid var(--stroke);background:#fff;color:var(--text);box-shadow:0 10px 24px rgba(15,23,42,.08);}\n";
  echo ".btn.primary{color:#fff;border-color:rgba(37,99,235,.25);background:linear-gradient(135deg,var(--pri),var(--pri2));box-shadow:0 12px 22px rgba(37,99,235,.22);}\n";
  echo ".btn.danger{color:#fff;border-color:rgba(239,68,68,.25);background:linear-gradient(135deg,#ef4444,#b91c1c);box-shadow:0 12px 22px rgba(239,68,68,.22);}\n";
  echo ".brand{margin:0 auto;text-align:center;font-weight:1000;letter-spacing:.6px;font-size:20px;white-space:nowrap;}\n";
  echo ".brand span{background:linear-gradient(90deg,var(--pri),var(--acc));-webkit-background-clip:text;background-clip:text;color:transparent;}\n";
  echo ".right{min-width:180px;display:flex;flex-direction:column;align-items:flex-end;gap:6px;}\n";
  echo ".userline{font-size:12.5px;color:var(--muted);line-height:1.2;}\n";
  echo ".container{max-width:1050px;margin:18px auto;padding:0 18px 22px;}\n";
  echo ".card{background:rgba(255,255,255,.94);border:1px solid var(--stroke);border-radius:var(--radius);box-shadow:var(--shadow);padding:18px;}\n";
  echo ".h1{margin:0 0 12px;font-size:18px;font-weight:1000;letter-spacing:.2px;}\n";
  echo ".muted{color:var(--muted);font-size:12.5px;}\n";
  echo ".msg{padding:10px 12px;border-radius:12px;margin:0 0 12px;font-weight:900;font-size:13px;border:1px solid var(--stroke);background:#fff;color:var(--muted);}\n";
  echo ".msg.ok{border-color:rgba(22,163,74,.28);background:rgba(22,163,74,.08);color:#166534;}\n";
  echo ".msg.warn{border-color:rgba(245,158,11,.28);background:rgba(245,158,11,.10);color:#92400e;}\n";
  echo ".msg.err{border-color:rgba(239,68,68,.28);background:rgba(239,68,68,.10);color:#991b1b;}\n";
  echo "label{display:block;font-weight:900;margin:10px 0 6px;}\n";
  echo "input,select,textarea{width:100%;padding:11px 12px;border-radius:12px;border:1px solid var(--stroke);background:#fff;outline:none;font-size:14px;}\n";
  echo "textarea{min-height:90px;resize:vertical;}\n";
  echo ".row{display:grid;grid-template-columns:1fr 1fr;gap:12px;}\n";
  echo "@media(max-width:720px){.row{grid-template-columns:1fr;}.brand{font-size:18px;}}\n";
  echo ".actions{display:flex;gap:10px;flex-wrap:wrap;margin-top:12px;}\n";
  echo "</style>\n</head>\n<body>\n";

  echo "<div class=\"topbar\">\n";
  echo "  <div class=\"left\">\n";
  echo "    <a class=\"btn\" href=\"dashboard.php\">🏠 Dashboard</a>\n";
  echo "  </div>\n";
  echo "  <div class=\"brand\"><span>{$brand}</span></div>\n";
  echo "  <div class=\"right\">\n";
  echo "    <div class=\"userline\"><b>{$safeUser}</b> • {$safeRole}</div>\n";
  echo "    <div style=\"display:flex;gap:10px\">\n";
  echo "      <a class=\"btn\" href=\"reset_password.php\">🔑 Reset</a>\n";
  echo "      <a class=\"btn primary\" href=\"logout.php\">Logout</a>\n";
  echo "    </div>\n";
  echo "  </div>\n";
  echo "</div>\n";

  echo "<div class=\"container\">\n";
  echo "  <div class=\"card\">\n";
  echo "    <div class=\"h1\">{$safeTitle}</div>\n";
}

function sb_page_footer(): void {
  echo "  </div>\n</div>\n</body>\n</html>";
}
