<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}

function fetch_all(mysqli $conn, string $sql): array {
    $rows = [];
    if ($res = $conn->query($sql)) {
        while($r = $res->fetch_assoc()) $rows[] = $r;
        $res->free();
    }
    return $rows;
}

$classes = fetch_all($conn, "SELECT id, name FROM classes ORDER BY name ASC");

$class_id   = (int)($_GET['class_id'] ?? 0);
$section_id = (int)($_GET['section_id'] ?? 0);
$date  = $_GET['date'] ?? date('Y-m-d');
$msg = '';

// Load sections for selected class
$sections = [];
if ($class_id > 0) {
    $st = $conn->prepare("SELECT id, name FROM sections WHERE class_id=? ORDER BY name ASC");
    if ($st) {
        $st->bind_param("i", $class_id);
        $st->execute();
        $sections = stmt_fetch_all_assoc($st);
        $st->close();
    }
}

// Determine teacher_id if logged-in user is a teacher
$teacher_id = null;
if (!empty($_SESSION['user_id'])) {
    $t = $conn->prepare("SELECT id FROM teachers WHERE user_id=? LIMIT 1");
    if ($t) {
        $uid = (int)$_SESSION['user_id'];
        $t->bind_param("i", $uid);
        $t->execute();
        $t->bind_result($tid);
        if ($t->fetch()) $teacher_id = (int)$tid;
        $t->close();
    }
}

if(isset($_POST['save_attendance'])){
    $class_id   = (int)($_POST['class_id'] ?? 0);
    $section_id = (int)($_POST['section_id'] ?? 0);
    $date       = $_POST['date'] ?? date('Y-m-d');

    if ($class_id<=0 || $section_id<=0) {
        $msg = "Please select class and section.";
    } else {
        // fetch students for class/section
        $stmt = $conn->prepare("SELECT id FROM students WHERE class_id=? AND section_id=? ORDER BY id ASC");
        $stmt->bind_param("ii", $class_id, $section_id);
        $stmt->execute();
        $stmt->bind_result($sid);

        // Upsert attendance per student (student_id + date)
        $up = $conn->prepare("INSERT INTO attendance (student_id, date, status_code, class_id, section_id, taken_by)
                              VALUES (?,?,?,?,?,?)
                              ON DUPLICATE KEY UPDATE status_code=VALUES(status_code), class_id=VALUES(class_id), section_id=VALUES(section_id), taken_by=VALUES(taken_by)");

        while($stmt->fetch()){
            $status = $_POST['st'][$sid] ?? 'A'; // P/A/L
            $tid = $teacher_id;
            $up->bind_param("issiii", $sid, $date, $status, $class_id, $section_id, $tid);
            $up->execute();
        }
        $msg = "Attendance saved.";
        $stmt->close();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Attendance</title>
    <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
    <div class="brand-text">
      <div class="brand-title">The Foundation Montessori</div>
      <div class="brand-sub">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link" href="../dashboard.php">Dashboard</a>
    <a class="nav-link" href="../students/student_list.php">Students</a>
    <a class="nav-link active" href="../attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="../staff/staff_list.php">Staff</a>
    <a class="nav-link" href="../fees/fees.php">Fees</a>
    <a class="nav-link" href="../exams/exams.php">Exams</a>
    <a class="nav-link" href="../reports/reports.php">Reports</a>
  </div>
</div>

<div class="content">
  <div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
    <div style="display:flex;gap:10px;align-items:center;">
      <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
      <a class="btn btn-white" href="javascript:history.back()">Back</a>
    </div>

    <div style="text-align:center;flex:1;">
      <div class="topbar-title" style="font-size:18px;">The Foundation Montessori</div>
      <div style="margin-top:6px;font-weight:700;"><?php echo htmlspecialchars($_SESSION['user'] ?? 'User'); ?></div>
    </div>

    <div style="display:flex;align-items:center;gap:10px;">
      <a class="btn btn-red" href="../logout.php">Log out</a>
    </div>
  </div>

  <div style="height:14px"></div>

  <div class="card">
    <h2 class="card-title">Class-wise Attendance</h2>
    <?php if(!empty($msg)){ echo '<div class="alert">'.htmlspecialchars($msg).'</div>'; } ?>

    <form method="GET" class="grid-3" style="margin-bottom:12px;">
      <div>
        <label>Class</label>
        <select name="class_id" required onchange="this.form.submit()">
          <option value="">Select</option>
          <?php foreach($classes as $c): ?>
            <option value="<?php echo (int)$c['id']; ?>" <?php echo ($class_id==(int)$c['id'])?'selected':''; ?>>
              <?php echo htmlspecialchars($c['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Section</label>
        <select name="section_id" required>
          <option value="">Select</option>
          <?php foreach($sections as $s): ?>
            <option value="<?php echo (int)$s['id']; ?>" <?php echo ($section_id==(int)$s['id'])?'selected':''; ?>>
              <?php echo htmlspecialchars($s['name']); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Date</label>
        <input type="date" name="date" value="<?php echo htmlspecialchars($date); ?>" required>
      </div>
      <div>
        <button class="btn btn-yellow" type="submit">Load</button>
        <a class="btn btn-white" href="?print=1&class_id=<?php echo (int)$class_id; ?>&section_id=<?php echo (int)$section_id; ?>&date=<?php echo urlencode($date); ?>">Auto Print</a>
      </div>
    </form>

    <?php
      if($class_id > 0 && $section_id > 0){
        // preload existing attendance for date
        $existing = [];
        $st2 = $conn->prepare("SELECT student_id, status_code FROM attendance WHERE date=? AND class_id=? AND section_id=?");
        $st2->bind_param("sii", $date, $class_id, $section_id);
        $st2->execute();
        $st2->bind_result($esid, $estatus);
        while($st2->fetch()){ $existing[(int)$esid] = $estatus ?: 'A'; }
        $st2->close();

        $st = $conn->prepare("
            SELECT st.id,
                   COALESCE(NULLIF(st.admission_no,''), st.student_id) AS admission_no,
                   COALESCE(NULLIF(TRIM(CONCAT(IFNULL(st.first_name,''),' ',IFNULL(st.last_name,''))),''), st.name) AS full_name,
                   sc.name AS section_name
            FROM students st
            LEFT JOIN sections sc ON sc.id = st.section_id
            WHERE st.class_id=? AND st.section_id=?
            ORDER BY st.id ASC
        ");
        $st->bind_param("ii", $class_id, $section_id);
        $st->execute();
        $st->bind_result($id, $adm, $full_name, $secname);

        echo '<form method="POST">';
        echo '<input type="hidden" name="class_id" value="'.(int)$class_id.'">';
        echo '<input type="hidden" name="section_id" value="'.(int)$section_id.'">';
        echo '<input type="hidden" name="date" value="'.htmlspecialchars($date).'">';

        echo '<table style="width:100%;border-collapse:collapse;">';
        echo '<tr>
              <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Admission No</th>
              <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Name</th>
              <th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Section</th>
              <th style="text-align:center;padding:8px;border-bottom:1px solid #e5e7eb;">Status</th>
              </tr>';

        while($st->fetch()){
            $cur = $existing[$id] ?? 'A';

            echo '<tr>';
            echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($adm ?? '').'</td>';
            echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($full_name ?? '').'</td>';
            echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($secname ?? '').'</td>';
            echo '<td style="padding:8px;text-align:center;border-bottom:1px solid #f1f5f9;">';
            echo '<select name="st['.(int)$id.']" style="max-width:200px;margin:0 auto;">';
            echo '<option value="P" '.($cur==='P'?'selected':'').'>Present</option>';
            echo '<option value="A" '.($cur==='A'?'selected':'').'>Absent</option>';
            echo '<option value="L" '.($cur==='L'?'selected':'').'>Leave</option>';
            echo '</select>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>';

        echo '<div style="margin-top:12px;display:flex;gap:10px;flex-wrap:wrap;">';
        echo '<button class="btn btn-red" type="submit" name="save_attendance">Save Attendance</button>';
        echo '</div>';

        echo '</form>';
        $st->close();
      }
    ?>

  </div>
</div>

<script>
  const params = new URLSearchParams(window.location.search);
  if(params.get('print') === '1'){ window.print(); }
</script>

</body>
</html>