<?php
// config/config.php (Final)

define('APP_DEBUG', false); // kaam ho gaya, ab false
define('APP_VERSION', '20260213-2'); // bump to refresh CSS/JS cache

// Session hardening
if (session_status() === PHP_SESSION_NONE) {
    $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
    ini_set('session.use_strict_mode', '1');
    ini_set('session.cookie_httponly', '1');
    ini_set('session.cookie_samesite', 'Lax');
    if ($isHttps) {
        ini_set('session.cookie_secure', '1');
    }
    session_start();
}

// DB credentials (as you provided)
define('DB_USER', 'velvetcr_Monti_db');
define('DB_PASS', 'Hassan@487@487');
define('DB_NAME', 'velvetcr_the_foundation_montessori');

// Try multiple hosts
$dbHosts = ['localhost', '127.0.0.1'];

mysqli_report(MYSQLI_REPORT_OFF);

$conn = null;
$lastErr = '';

foreach ($dbHosts as $h) {
    $tmp = @new mysqli($h, DB_USER, DB_PASS, DB_NAME);

    if (!$tmp->connect_errno) {
        $conn = $tmp;
        @$conn->set_charset('utf8mb4');
        break;
    }

    $lastErr = "HOST={$h} | ({$tmp->connect_errno}) {$tmp->connect_error}";
    error_log("DB CONNECT ERROR: " . $lastErr);
}

if (!$conn) {
    http_response_code(500);

    if (APP_DEBUG) {
        die("Database connection failed: " . htmlspecialchars($lastErr));
    }
    die("Database connection failed. Please contact administrator.");
}

// Helper
function e($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }


/**
 * Fetch all rows from a mysqli_stmt WITHOUT mysqlnd (replaces $stmt->get_result()).
 * Usage:
 *   $stmt->execute();
 *   $rows = stmt_fetch_all_assoc($stmt);
 */
function stmt_fetch_all_assoc(mysqli_stmt $stmt): array {
    $rows = [];

    // Buffer results so metadata is available consistently
    @$stmt->store_result();

    $meta = $stmt->result_metadata();
    if (!$meta) { return $rows; }

    $fields = $meta->fetch_fields();
    $row = [];
    $bind = [];

    foreach ($fields as $f) {
        $row[$f->name] = null;
        $bind[] = &$row[$f->name];
    }

    call_user_func_array([$stmt, 'bind_result'], $bind);

    while ($stmt->fetch()) {
        $r = [];
        foreach ($row as $k => $v) { $r[$k] = $v; }
        $rows[] = $r;
    }

    $meta->free();
    return $rows;
}
