<?php
include 'config/config.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: index.php"); exit(); }

$userName = htmlspecialchars((string)($_SESSION['user'] ?? 'User'), ENT_QUOTES, 'UTF-8');
$current = $_SERVER['SCRIPT_NAME'] ?? '';

function active($current, $needle){
    return (strpos($current, $needle) !== false) ? 'active' : '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Dashboard - The Foundation Montessori</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="assets/img/logo.svg" alt="Logo"></div>
    <div class="brand-text">
      <div class="brand-title">The Foundation Montessori</div>
      <div class="brand-sub">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link <?php echo active($current,'/dashboard.php'); ?>" href="dashboard.php">Dashboard</a>
    <a class="nav-link <?php echo active($current,'/students/'); ?>" href="students/student_list.php">Students</a>
    <a class="nav-link <?php echo active($current,'/attendance/'); ?>" href="attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="staff/staff_list.php">Staff</a>
    <a class="nav-link <?php echo active($current,'/fees/'); ?>" href="fees/fees.php">Fees</a>
    <a class="nav-link <?php echo active($current,'/exams/'); ?>" href="exams/exams.php">Exams</a>
    <a class="nav-link <?php echo active($current,'/reports/'); ?>" href="reports/reports.php">Reports</a>
  </div>

  <div class="sidebar-footer">
    <div class="small">Logged in as</div>
    <div class="strong"><?php echo $userName; ?></div>
  </div>
</div>

<div class="content">

  <div class="topbar" style="min-height:115px;">
    <div style="display:flex;gap:10px;align-items:center;">
      <a class="btn btn-yellow" href="dashboard.php">Dashboard</a>
      <a class="btn btn-ice" href="javascript:history.back()">Back</a>
    </div>

    <div style="text-align:center;flex:1;">
      <div class="topbar-title">The Foundation Montessori</div>
      <div style="margin-top:8px;font-weight:800;"><?php echo $userName; ?></div>
    </div>

    <div style="display:flex;gap:10px;align-items:center;">
      <a class="btn btn-red" href="logout.php">Log out</a>
    </div>
  </div>

  <div class="dashboard-grid">
    <div>
      <div class="cards">
        <a class="card" href="students/student_list.php">
          <div class="card-title">Students</div>
          <div class="card-sub">Add / List / ID Card</div>
        </a>

        <a class="card" href="attendance/attendance.php">
          <div class="card-title">Attendance</div>
          <div class="card-sub">Class-wise attendance</div>
        </a>

        <a class="card" href="staff/staff_list.php">
          <div class="card-title">Staff</div>
          <div class="card-sub">Teachers / Accountant / Salary</div>
        </a>

        <a class="card" href="fees/fees.php">
          <div class="card-title">Fees</div>
          <div class="card-sub">Receive / receipts / print</div>
        </a>

        <a class="card" href="exams/exams.php">
          <div class="card-title">Exams</div>
          <div class="card-sub">Marks / results</div>
        </a>

        <a class="card" href="reports/reports.php">
          <div class="card-title">Reports</div>
          <div class="card-sub">Print & summary</div>
        </a>
      </div>
    </div>

    <div class="card calendar-card">
      <div class="calendar-head">
        <div class="month" id="calMonth">Calendar</div>
        <div style="display:flex;gap:8px;">
          <button class="btn btn-white btn-sm" type="button" id="calPrev">‹</button>
          <button class="btn btn-white btn-sm" type="button" id="calNext">›</button>
          <button class="btn btn-yellow btn-sm" type="button" id="calToday">Today</button>
        </div>
      </div>
      <div class="calendar-grid" id="calGrid"></div>
      <div style="margin-top:12px;color:var(--muted);font-weight:800;font-size:13px;">
        Tip: You can use this calendar for quick planning. (Top-right 4×5 inch size)
      </div>
    </div>
  </div>

  <script>
  (function(){
    const monthEl = document.getElementById('calMonth');
    const gridEl  = document.getElementById('calGrid');
    const btnPrev = document.getElementById('calPrev');
    const btnNext = document.getElementById('calNext');
    const btnToday= document.getElementById('calToday');

    const dows = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];
    function pad(n){ return n<10?('0'+n):(''+n); }

    let view = new Date();
    view.setDate(1);

    function render(){
      const y = view.getFullYear();
      const m = view.getMonth();

      const title = view.toLocaleString(undefined,{month:'long',year:'numeric'});
      monthEl.textContent = title;

      gridEl.innerHTML = '';
      for(const d of dows){
        const el = document.createElement('div');
        el.className = 'cal-dow';
        el.textContent = d;
        gridEl.appendChild(el);
      }

      const firstDow = new Date(y,m,1).getDay();
      const daysInMonth = new Date(y,m+1,0).getDate();
      const prevDays = new Date(y,m,0).getDate();

      // 6 weeks * 7 = 42 cells
      const today = new Date();
      const todayKey = today.getFullYear()+'-'+pad(today.getMonth()+1)+'-'+pad(today.getDate());

      for(let i=0;i<42;i++){
        const cell = document.createElement('div');
        cell.className = 'cal-day';

        let dayNum, cellDate;
        if(i < firstDow){
          dayNum = prevDays - (firstDow-1-i);
          cell.classList.add('muted');
          cellDate = new Date(y,m-1,dayNum);
        } else if(i >= firstDow + daysInMonth){
          dayNum = (i - (firstDow + daysInMonth)) + 1;
          cell.classList.add('muted');
          cellDate = new Date(y,m+1,dayNum);
        } else {
          dayNum = (i - firstDow) + 1;
          cellDate = new Date(y,m,dayNum);
        }

        const key = cellDate.getFullYear()+'-'+pad(cellDate.getMonth()+1)+'-'+pad(cellDate.getDate());
        if(key === todayKey) cell.classList.add('today');

        cell.textContent = dayNum;
        gridEl.appendChild(cell);
      }
    }

    btnPrev.addEventListener('click', function(){ view.setMonth(view.getMonth()-1); render(); });
    btnNext.addEventListener('click', function(){ view.setMonth(view.getMonth()+1); render(); });
    btnToday.addEventListener('click', function(){ view = new Date(); view.setDate(1); render(); });

    render();
  })();
  </script>

</div>

</div>
</body>
</html>