<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Exams</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
    <div class=\"brand-text\">
      <div class=\"brand-title\">The Foundation Montessori</div>
      <div class=\"brand-sub\">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link" href="../dashboard.php">Dashboard</a>
    <a class="nav-link" href="../students/add_student.php">Students</a>
    <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="../staff/staff_list.php">Staff</a>
    <a class="nav-link" href="../fees/fees.php">Fees</a>
    <a class="nav-link" href="../exams/exams.php">Exams</a>
    <a class="nav-link" href="../reports/reports.php">Reports</a>
  </div>

  <div class="footer">
    
  </div>
</div>

<div class="content">

<div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
  <div style="display:flex;gap:10px;align-items:center;">
    <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
    <a class="btn btn-white" href="javascript:history.back()">Back</a>
  </div>

  <div style="text-align:center;flex:1;">
    <div class="topbar-title" style="font-size:18px;">The Foundation Montessori</div>
    <div style="margin-top:6px;font-weight:700;">Exams — <?php echo htmlspecialchars($_SESSION['user'] ?? 'User'); ?></div>
  </div>

  <div style="display:flex;align-items:center;gap:10px;">
    <a class="btn btn-red" href="../logout.php">Log out</a>
  </div>
</div>

<div style="height:14px"></div>
<div class="card">

<h2 class="card-title">Exams</h2>
<p style="color:var(--muted);margin-top:6px;">New theme applied. Next step: add exams + marks + class-wise reports.</p>

<div style="margin-top:14px;display:flex;gap:10px;flex-wrap:wrap;">
  <a class="btn btn-blue" href="#">Add Exam</a>
  <a class="btn btn-white" href="#">Marks Entry</a>
  <a class="btn btn-yellow" href="../reports/reports.php">Reports</a>
  <a class="btn btn-white" href="?print=1">Auto Print</a>
</div>

<?php
if(isset($_GET['print']) && $_GET['print']=='1'){ echo "<script>window.print();</script>"; }
?>

</div>
</div>
</body>
</html>