<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant','fee'], true)) {
    http_response_code(403);
    die("Access denied.");
}

$from = trim((string)($_GET['from'] ?? ''));
$to   = trim((string)($_GET['to'] ?? ''));
$q    = trim((string)($_GET['q'] ?? ''));

$where = "WHERE 1=1 ";
$params = [];
$types = "";

if($from !== ''){
  $where .= " AND r.received_at >= ? ";
  $params[] = $from; $types .= "s";
}
if($to !== ''){
  $where .= " AND r.received_at <= ? ";
  $params[] = $to; $types .= "s";
}
if($q !== ''){
  $like = "%{$q}%";
  $where .= " AND (s.name LIKE ? OR s.admission_no LIKE ? OR r.fee_month LIKE ?) ";
  $params[] = $like; $params[] = $like; $params[] = $like; $types .= "sss";
}

$sql = "SELECT r.id, r.received_at, r.fee_month, r.amount, r.method, r.notes,
               s.admission_no, s.name, s.class, s.section
        FROM fee_receipts r
        LEFT JOIN students s ON s.id = r.student_id
        {$where}
        ORDER BY r.id DESC
        LIMIT 500";

$rows = [];
$stmt = $conn->prepare($sql);
if($stmt){
  if($types !== ''){
    $stmt->bind_param($types, ...$params);
  }
  $stmt->execute();
  $rows = stmt_fetch_all_assoc($stmt);
  $stmt->close();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Fee Receipts</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link active" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="fees.php">Fees</a>
        <a class="btn btn-white" href="receive_fee.php">+ Receive Fee</a>
      </div>

      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Fee Receipts</div>
        <div style="margin-top:6px;font-weight:700;">Latest 500</div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Receipts</h2>

        <form method="get" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;align-items:center;">
          <input class="input" type="date" name="from" value="<?php echo e($from); ?>">
          <input class="input" type="date" name="to" value="<?php echo e($to); ?>">
          <input class="input" type="text" name="q" value="<?php echo e($q); ?>" placeholder="Student / admission / month">
          <button class="btn btn-blue" type="submit">Filter</button>
          <a class="btn btn-white" href="fee_list.php">Reset</a>
        </form>

        <div style="height:12px"></div>

        <div style="overflow:auto">
          <table class="table">
            <thead>
              <tr>
                <th>ID</th>
                <th>Date</th>
                <th>Month</th>
                <th>Student</th>
                <th>Class</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Notes</th>
              </tr>
            </thead>
            <tbody>
              <?php if(!$rows): ?>
                <tr><td colspan="8" style="text-align:center;color:var(--muted);">No receipts found.</td></tr>
              <?php else: foreach($rows as $r): ?>
                <tr>
                  <td><?php echo e($r['id']); ?></td>
                  <td><?php echo e($r['received_at']); ?></td>
                  <td><?php echo e($r['fee_month']); ?></td>
                  <td><?php echo e($r['admission_no'].' - '.$r['name']); ?></td>
                  <td><?php echo e($r['class'].'/'.$r['section']); ?></td>
                  <td style="font-weight:800;"><?php echo e(number_format((float)$r['amount'],2)); ?></td>
                  <td><?php echo e($r['method']); ?></td>
                  <td><?php echo e($r['notes']); ?></td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

        <p style="margin-top:10px;color:var(--muted);">
          Note: Run <b>db_upgrade_v7_staff.sql</b> to create table <b>fee_receipts</b>.
        </p>
      </div>
    </section>
  </main>
</div>
</body>
</html>
