<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant','fee'], true)) {
    http_response_code(403);
    die("Access denied.");
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Fees</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link active" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
        <a class="btn btn-white" href="javascript:history.back()">Back</a>
      </div>

      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Fees</div>
        <div style="margin-top:6px;font-weight:700;">Fee Receipt System</div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Fees</h2>
        <p style="color:var(--muted);margin-top:6px;">
          Receive fee, view receipts, and print.
        </p>

        <div style="margin-top:14px;display:flex;gap:10px;flex-wrap:wrap;">
          <a class="btn btn-blue" href="receive_fee.php">Receive Fee</a>
          <a class="btn btn-white" href="fee_list.php">Receipts List</a>
          <a class="btn btn-yellow" href="../reports/reports.php">Reports</a>
          <a class="btn btn-white" href="?print=1">Auto Print</a>
        </div>

        <?php
        if(isset($_GET['print']) && $_GET['print']=='1'){ echo "<script>window.print();</script>"; }
        ?>

        <p style="margin-top:10px;color:var(--muted);">
          Note: Create a <b>fee</b> role user for fee counter (teacher or cashier).
        </p>
      </div>
    </section>
  </main>
</div>
</body>
</html>