<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant','fee'], true)) {
    http_response_code(403);
    die("Access denied.");
}

function fetch_all(mysqli $conn, string $sql): array {
    $rows = [];
    if ($res = $conn->query($sql)) {
        while($r = $res->fetch_assoc()) $rows[] = $r;
        $res->free();
    }
    return $rows;
}

$students = fetch_all($conn, "SELECT id, admission_no, name, class, section FROM students ORDER BY id DESC LIMIT 500");

$error=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $student_id = (int)($_POST['student_id'] ?? 0);
  $fee_month  = trim((string)($_POST['fee_month'] ?? date('Y-m')));
  $amount     = (float)($_POST['amount'] ?? 0);
  $method     = trim((string)($_POST['method'] ?? 'cash'));
  $notes      = trim((string)($_POST['notes'] ?? ''));
  $received_at= trim((string)($_POST['received_at'] ?? date('Y-m-d')));
  $received_by= (int)($_SESSION['user_id'] ?? 0);

  if($student_id<=0 || $amount<=0){
    $error="Please select student and enter amount.";
  } else {
    $stmt = $conn->prepare("INSERT INTO fee_receipts (student_id, fee_month, amount, method, received_at, received_by, notes)
                            VALUES (?,?,?,?,?,?,?)");
    if(!$stmt){
      $error="DB error: ".$conn->error." (Run db_upgrade_v7_staff.sql)";
    } else {
      $stmt->bind_param("isdssis", $student_id, $fee_month, $amount, $method, $received_at, $received_by, $notes);
      if($stmt->execute()){
        $rid = (int)$stmt->insert_id;
        $ok="Fee received saved. Receipt ID: {$rid}";
      } else $error="Save failed.";
      $stmt->close();
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Receive Fee</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link active" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="fees.php">Fees</a>
        <a class="btn btn-white" href="javascript:history.back()">Back</a>
      </div>

      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Receive Fee</div>
        <div style="margin-top:6px;font-weight:700;">Fee Receipt Entry</div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Receive Fee</h2>

        <?php if($error): ?><div class="alert alert-danger"><?php echo e($error); ?></div><?php endif; ?>
        <?php if($ok): ?><div class="alert alert-success"><?php echo e($ok); ?></div><?php endif; ?>

        <form method="post" style="margin-top:12px;display:grid;gap:10px;max-width:820px;">
          <div>
            <label class="label">Student</label>
            <select class="input" name="student_id" required>
              <option value="">Select student...</option>
              <?php foreach($students as $s): ?>
                <option value="<?php echo (int)$s['id']; ?>">
                  <?php echo e($s['admission_no'].' - '.$s['name'].' ('.$s['class'].'/'.$s['section'].')'); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="grid2">
            <div>
              <label class="label">Fee Month</label>
              <input class="input" type="month" name="fee_month" value="<?php echo e(date('Y-m')); ?>">
            </div>
            <div>
              <label class="label">Received Date</label>
              <input class="input" type="date" name="received_at" value="<?php echo e(date('Y-m-d')); ?>">
            </div>
          </div>

          <div class="grid2">
            <div>
              <label class="label">Amount</label>
              <input class="input" type="number" step="0.01" name="amount" required>
            </div>
            <div>
              <label class="label">Method</label>
              <select class="input" name="method">
                <option value="cash">Cash</option>
                <option value="bank">Bank</option>
                <option value="online">Online</option>
              </select>
            </div>
          </div>

          <div>
            <label class="label">Notes</label>
            <textarea class="input" name="notes" rows="3" placeholder="Optional"></textarea>
          </div>

          <div style="display:flex;gap:10px;flex-wrap:wrap;">
            <button class="btn btn-blue" type="submit">Save Receipt</button>
            <a class="btn btn-white" href="fee_list.php">View Receipts</a>
          </div>

          <p style="margin-top:10px;color:var(--muted);">
            Tip: Create a user with role <b>fee</b> for fee receiving staff.
          </p>
        </form>
      </div>
    </section>
  </main>
</div>
</body>
</html>
