<?php
include_once __DIR__ . '/../config/config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user'])) {
    header("Location: " . (dirname($_SERVER['SCRIPT_NAME']) === '/' ? '' : dirname($_SERVER['SCRIPT_NAME'])) . "/index.php");
    exit();
}

// Base path so links work even if folder name changes
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
if ($base === '/') { $base = ''; }

$current = $_SERVER['SCRIPT_NAME'] ?? '';

function is_active($current, $path) {
    return (strpos($current, $path) !== false) ? 'active' : '';
}

$userName = htmlspecialchars((string)($_SESSION['user'] ?? ''), ENT_QUOTES, 'UTF-8');
?>