<?php
// Requires: include partials/auth.php before this file
$pageTitle = $pageTitle ?? 'Dashboard';
$backLink = $backLink ?? ($base . '/dashboard.php');
$backLabel = $backLabel ?? 'Dashboard';

// Left menu links (NO duplicates)
$menu = [
    ['label'=>'Dashboard',  'href'=>$base.'/dashboard.php',              'match'=>'/dashboard.php'],
    ['label'=>'Students',   'href'=>$base.'/students/student_list.php', 'match'=>'/students/'],
    ['label'=>'Attendance', 'href'=>$base.'/attendance/attendance.php', 'match'=>'/attendance/'],
    ['label'=>'Fees',       'href'=>$base.'/fees/fees.php',             'match'=>'/fees/'],
    ['label'=>'Exams',      'href'=>$base.'/exams/exams.php',           'match'=>'/exams/'],
    ['label'=>'Staff',      'href'=>$base.'/staff/staff_list.php',     'match'=>'/staff/'],
    ['label'=>'Reports',    'href'=>$base.'/reports/reports.php',       'match'=>'/reports/'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?> - The Foundation Montessori</title>
  <link rel="stylesheet" href="<?php echo htmlspecialchars($base.'/assets/css/style.css?v='.APP_VERSION, ENT_QUOTES, 'UTF-8'); ?>">
</head>
<body>

<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo">
        <img src="<?php echo htmlspecialchars($base.'/assets/img/logo.svg', ENT_QUOTES, 'UTF-8'); ?>" alt="Logo">
      </div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>

    <nav class="nav">
      <?php foreach ($menu as $m): ?>
        <a class="nav-link <?php echo is_active($current, $m['match']); ?>"
           href="<?php echo htmlspecialchars($m['href'], ENT_QUOTES, 'UTF-8'); ?>">
          <?php echo htmlspecialchars($m['label'], ENT_QUOTES, 'UTF-8'); ?>
        </a>
      <?php endforeach; ?>
    </nav>

    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo $userName; ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar">
      <div class="topbar-left">
        <a class="btn btn-ghost" href="<?php echo htmlspecialchars($backLink, ENT_QUOTES, 'UTF-8'); ?>">
          ← <?php echo htmlspecialchars($backLabel, ENT_QUOTES, 'UTF-8'); ?>
        </a>
        <div class="topbar-title"><?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?></div>
      </div>

      <div class="topbar-right">
        <div class="userbox">
          <div class="user-name"><?php echo $userName; ?></div>
          <a class="btn btn-danger btn-sm" href="<?php echo htmlspecialchars($base.'/logout.php', ENT_QUOTES, 'UTF-8'); ?>">Log off</a>
        </div>
      </div>
    </header>

    <section class="content">
