<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Reports</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
    <div class=\"brand-text\">
      <div class=\"brand-title\">The Foundation Montessori</div>
      <div class=\"brand-sub\">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link" href="../dashboard.php">Dashboard</a>
    <a class="nav-link" href="../students/add_student.php">Students</a>
    <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="../staff/staff_list.php">Staff</a>
    <a class="nav-link" href="../fees/fees.php">Fees</a>
    <a class="nav-link" href="../exams/exams.php">Exams</a>
    <a class="nav-link" href="../reports/reports.php">Reports</a>
  </div>

  <div class="footer">
    
  </div>
</div>

<div class="content">

<div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
  <div style="display:flex;gap:10px;align-items:center;">
    <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
    <a class="btn btn-white" href="javascript:history.back()">Back</a>
  </div>

  <div style="text-align:center;flex:1;">
    <div class="topbar-title" style="font-size:18px;">The Foundation Montessori</div>
    <div style="margin-top:6px;font-weight:700;">Reports — <?php echo htmlspecialchars($_SESSION['user'] ?? 'User'); ?></div>
  </div>

  <div style="display:flex;align-items:center;gap:10px;">
    <a class="btn btn-red" href="../logout.php">Log out</a>
  </div>
</div>

<div style="height:14px"></div>
<div class="card">

<h2 class="card-title">Reports</h2>

<form method="GET">
  <div style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:12px;align-items:end;">
    <div>
      <label>Class</label>
      <input type="text" name="class" value="<?php echo htmlspecialchars($_GET['class'] ?? ''); ?>">
    </div>
    <div>
      <label>Date</label>
      <input type="date" name="date" value="<?php echo htmlspecialchars($_GET['date'] ?? date('Y-m-d')); ?>">
    </div>
    <div>
      <button class="btn btn-blue" type="submit">Generate</button>
    </div>
  </div>
</form>

<div style="margin-top:12px;display:flex;gap:10px;">
  <a class="btn btn-white" href="?<?php echo http_build_query(array_merge($_GET,['print'=>1])); ?>">Auto Print</a>
</div>

<?php
$class = $_GET['class'] ?? '';
$date = $_GET['date'] ?? date('Y-m-d');

if($class){
    echo "<h3 style='margin-top:16px;'>Attendance Report - Class ".htmlspecialchars($class)." (".htmlspecialchars($date).")</h3>";
    $stmt = $conn->prepare("SELECT
                              COALESCE(NULLIF(TRIM(CONCAT(IFNULL(s.first_name,''),' ',IFNULL(s.last_name,''))),''), s.name) AS student_name,
                              COALESCE(sec.name, s.section) AS section_name,
                              COALESCE(
                                CASE
                                  WHEN a.status_code='P' THEN 'Present'
                                  WHEN a.status_code='A' THEN 'Absent'
                                  WHEN a.status_code='L' THEN 'Leave'
                                  ELSE NULL
                                END,
                                a.status,
                                '-'
                              ) AS status_txt
                            FROM students s
                            LEFT JOIN classes c ON c.id = s.class_id
                            LEFT JOIN sections sec ON sec.id = s.section_id
                            LEFT JOIN attendance a ON a.student_id = s.id AND a.date = ?
                            WHERE (c.name = ? OR s.class = ?)
                            ORDER BY student_name");
    $stmt->bind_param("sss",$date,$class,$class);
    $stmt->execute();
    $rows = stmt_fetch_all_assoc($stmt);

    echo '<table class="table" style="margin-top:8px;">';
    echo '<tr><th>Student</th><th style="text-align:center;">Section</th><th style="text-align:center;">Status</th></tr>';
    foreach($rows as $r){
        echo '<tr>';
        echo '<td>'.htmlspecialchars($r['student_name']).'</td>';
        echo '<td style="text-align:center;">'.htmlspecialchars($r['section_name']).'</td>';
        echo '<td style="text-align:center;">'.htmlspecialchars($r['status_txt']).'</td>';
        echo '</tr>';
    }
    echo '</table>';
} else {
    echo "<p style='margin-top:14px;color:var(--muted);'>Tip: Class select karein to class-wise report generate ho gi.</p>";
}

if(isset($_GET['print']) && $_GET['print']=='1'){ echo "<script>window.print();</script>"; }
?>

</div>
</div>
</body>
</html>