<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant'], true)) {
    http_response_code(403);
    die("Access denied.");
}

$id = (int)($_GET['id'] ?? 0);

$staff = [
  'staff_code'=>'',
  'full_name'=>'',
  'designation'=>'Teacher',
  'phone'=>'',
  'monthly_salary'=>'0',
  'status'=>'active'
];

if($id>0){
  $stmt = $conn->prepare("SELECT staff_code, full_name, designation, phone, monthly_salary, status FROM staff WHERE id=?");
  if($stmt){
    $stmt->bind_param("i",$id);
    $stmt->execute();
    $stmt->bind_result($staff_code,$full_name,$designation,$phone,$monthly_salary,$status);
    if($stmt->fetch()){
      $staff['staff_code']=$staff_code;
      $staff['full_name']=$full_name;
      $staff['designation']=$designation;
      $staff['phone']=$phone;
      $staff['monthly_salary']=$monthly_salary;
      $staff['status']=$status;
    }
    $stmt->close();
  }
}

$error=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $staff_code = trim((string)($_POST['staff_code'] ?? ''));
  $full_name  = trim((string)($_POST['full_name'] ?? ''));
  $designation= trim((string)($_POST['designation'] ?? 'Teacher'));
  $phone      = trim((string)($_POST['phone'] ?? ''));
  $monthly_salary = (float)($_POST['monthly_salary'] ?? 0);
  $status     = trim((string)($_POST['status'] ?? 'active'));

  if($full_name===''){
    $error = "Name is required.";
  } else {
    if($id>0){
      $stmt = $conn->prepare("UPDATE staff SET staff_code=?, full_name=?, designation=?, phone=?, monthly_salary=?, status=? WHERE id=?");
      if(!$stmt){ $error="DB error: ".$conn->error; }
      else{
        $stmt->bind_param("ssssdsi",$staff_code,$full_name,$designation,$phone,$monthly_salary,$status,$id);
        if($stmt->execute()){
          $ok="Updated successfully.";
        } else $error="Save failed.";
        $stmt->close();
      }
    } else {
      $stmt = $conn->prepare("INSERT INTO staff (staff_code, full_name, designation, phone, monthly_salary, status) VALUES (?,?,?,?,?,?)");
      if(!$stmt){ $error="DB error: ".$conn->error; }
      else{
        $stmt->bind_param("sssdss",$staff_code,$full_name,$designation,$phone,$monthly_salary,$status);
        if($stmt->execute()){
          $ok="Added successfully.";
          $id=(int)$stmt->insert_id;
        } else $error="Save failed.";
        $stmt->close();
      }
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $id>0?'Edit Staff':'Add Staff'; ?></title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link active" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="staff_list.php">Back</a>
      </div>

      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;"><?php echo $id>0?'Edit Staff':'Add Staff'; ?></div>
        <div style="margin-top:6px;font-weight:700;">Teachers / Accountant / Fee Staff</div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title"><?php echo $id>0?'Edit Staff':'Add Staff'; ?></h2>

        <?php if($error): ?><div class="alert alert-danger"><?php echo e($error); ?></div><?php endif; ?>
        <?php if($ok): ?><div class="alert alert-success"><?php echo e($ok); ?></div><?php endif; ?>

        <form method="post" style="margin-top:12px;display:grid;gap:10px;max-width:760px;">
          <div class="grid2">
            <div>
              <label class="label">Staff Code (optional)</label>
              <input class="input" name="staff_code" value="<?php echo e($staff['staff_code']); ?>" placeholder="T001 / A001 ...">
            </div>
            <div>
              <label class="label">Full Name *</label>
              <input class="input" name="full_name" value="<?php echo e($staff['full_name']); ?>" required>
            </div>
          </div>

          <div class="grid2">
            <div>
              <label class="label">Designation</label>
              <select class="input" name="designation">
                <?php
                  $opts=['Teacher','Accountant','Fee Receiver','Admin Staff','Other'];
                  foreach($opts as $o){
                    $sel = ($staff['designation']===$o)?'selected':'';
                    echo "<option value=\"".e($o)."\" {$sel}>".e($o)."</option>";
                  }
                ?>
              </select>
            </div>
            <div>
              <label class="label">Phone</label>
              <input class="input" name="phone" value="<?php echo e($staff['phone']); ?>">
            </div>
          </div>

          <div class="grid2">
            <div>
              <label class="label">Monthly Salary</label>
              <input class="input" type="number" step="0.01" name="monthly_salary" value="<?php echo e($staff['monthly_salary']); ?>">
            </div>
            <div>
              <label class="label">Status</label>
              <select class="input" name="status">
                <option value="active" <?php echo $staff['status']==='active'?'selected':''; ?>>Active</option>
                <option value="inactive" <?php echo $staff['status']==='inactive'?'selected':''; ?>>Inactive</option>
              </select>
            </div>
          </div>

          <div style="display:flex;gap:10px;flex-wrap:wrap;">
            <button class="btn btn-blue" type="submit">Save</button>
            <a class="btn btn-white" href="staff_list.php">Cancel</a>
          </div>
        </form>

        <p style="margin-top:10px;color:var(--muted);">
          Note: This creates staff record. To create login accounts for teachers/accountant/fee receiver, add them in DB table <b>users</b> with role.
        </p>
      </div>
    </section>
  </main>
</div>
</body>
</html>
