<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant'], true)) {
    http_response_code(403);
    die("Access denied.");
}

$att_date = trim((string)($_GET['date'] ?? date('Y-m-d')));
$staff_id_filter = (int)($_GET['staff_id'] ?? 0);

function fetch_all(mysqli $conn, string $sql): array {
    $rows = [];
    if ($res = $conn->query($sql)) {
        while($r = $res->fetch_assoc()) $rows[] = $r;
        $res->free();
    }
    return $rows;
}

$staff = fetch_all($conn, "SELECT id, staff_code, full_name, designation FROM staff WHERE status='active' ORDER BY full_name ASC");

$existing = [];
$stmt = $conn->prepare("SELECT staff_id, status FROM staff_attendance WHERE att_date=?");
if($stmt){
  $stmt->bind_param("s",$att_date);
  $stmt->execute();
  $rows = stmt_fetch_all_assoc($stmt);
  foreach($rows as $r){
    $existing[(int)$r['staff_id']] = $r['status'];
  }
  $stmt->close();
}

$msg=''; $err='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $att_date = trim((string)($_POST['att_date'] ?? date('Y-m-d')));
  $statuses = $_POST['status'] ?? [];
  if(!is_array($statuses)) $statuses = [];

  $stmt = $conn->prepare("INSERT INTO staff_attendance (staff_id, att_date, status, marked_by)
                          VALUES (?,?,?,?)
                          ON DUPLICATE KEY UPDATE status=VALUES(status), marked_by=VALUES(marked_by)");
  if(!$stmt){
    $err="DB error: ".$conn->error." (Run db_upgrade_v7_staff.sql)";
  } else {
    $marked_by = (int)($_SESSION['user_id'] ?? 0);
    foreach($staff as $s){
      $sid = (int)$s['id'];
      if($staff_id_filter>0 && $sid!==$staff_id_filter) continue;

      $st = (string)($statuses[$sid] ?? 'present');
      if(!in_array($st,['present','absent','leave'],true)) $st='present';

      $stmt->bind_param("issi",$sid,$att_date,$st,$marked_by);
      $stmt->execute();
    }
    $stmt->close();
    $msg="Attendance saved for {$att_date}";
    // reload existing
    $existing = [];
    $q = $conn->prepare("SELECT staff_id, status FROM staff_attendance WHERE att_date=?");
    if($q){
      $q->bind_param("s",$att_date);
      $q->execute();
      $rows = stmt_fetch_all_assoc($q);
      foreach($rows as $x){ $existing[(int)$x['staff_id']] = $x['status']; }
      $q->close();
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Staff Attendance</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link active" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="staff_list.php">Staff</a>
        <a class="btn btn-white" href="javascript:history.back()">Back</a>
      </div>
      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Staff Attendance</div>
        <div style="margin-top:6px;font-weight:700;"><?php echo e($att_date); ?></div>
      </div>
      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Mark Attendance</h2>

        <?php if($err): ?><div class="alert alert-danger"><?php echo e($err); ?></div><?php endif; ?>
        <?php if($msg): ?><div class="alert alert-success"><?php echo e($msg); ?></div><?php endif; ?>

        <form method="get" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;align-items:center;">
          <label class="label" style="margin:0;">Date</label>
          <input class="input" type="date" name="date" value="<?php echo e($att_date); ?>">
          <button class="btn btn-blue" type="submit">Load</button>
          <a class="btn btn-white" href="staff_attendance.php">Today</a>
        </form>

        <div style="height:12px"></div>

        <form method="post">
          <input type="hidden" name="att_date" value="<?php echo e($att_date); ?>">

          <div style="overflow:auto">
            <table class="table">
              <thead>
                <tr>
                  <th>ID</th>
                  <th>Code</th>
                  <th>Name</th>
                  <th>Designation</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach($staff as $s):
                  $sid = (int)$s['id'];
                  if($staff_id_filter>0 && $sid!==$staff_id_filter) continue;
                  $cur = $existing[$sid] ?? 'present';
              ?>
                <tr>
                  <td><?php echo $sid; ?></td>
                  <td><?php echo e($s['staff_code']); ?></td>
                  <td><?php echo e($s['full_name']); ?></td>
                  <td><?php echo e($s['designation']); ?></td>
                  <td>
                    <select class="input" name="status[<?php echo $sid; ?>]" style="max-width:180px;">
                      <option value="present" <?php echo $cur==='present'?'selected':''; ?>>Present</option>
                      <option value="absent" <?php echo $cur==='absent'?'selected':''; ?>>Absent</option>
                      <option value="leave" <?php echo $cur==='leave'?'selected':''; ?>>Leave</option>
                    </select>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>

          <div style="margin-top:12px;display:flex;gap:10px;flex-wrap:wrap;">
            <button class="btn btn-blue" type="submit">Save Attendance</button>
            <a class="btn btn-white" href="staff_list.php">Back</a>
          </div>

          <p style="margin-top:10px;color:var(--muted);">
            Tip: This page is for teacher/accountant staff. Student attendance is separate.
          </p>
        </form>
      </div>
    </section>
  </main>
</div>
</body>
</html>
