<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant'], true)) {
    http_response_code(403);
    die("Access denied.");
}

function fetch_all(mysqli $conn, string $sql): array {
    $rows = [];
    if ($res = $conn->query($sql)) {
        while($r = $res->fetch_assoc()) $rows[] = $r;
        $res->free();
    }
    return $rows;
}

$q = trim((string)($_GET['q'] ?? ''));
$where = '';
if ($q !== '') {
    $qSafe = $conn->real_escape_string($q);
    $where = "WHERE full_name LIKE '%{$qSafe}%' OR staff_code LIKE '%{$qSafe}%' OR designation LIKE '%{$qSafe}%'";
}

$rows = fetch_all($conn, "SELECT id, staff_code, full_name, designation, phone, monthly_salary, status
                          FROM staff {$where} ORDER BY id DESC");
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Staff</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link active" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
        <a class="btn btn-white" href="javascript:history.back()">Back</a>
      </div>

      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Staff</div>
        <div style="margin-top:6px;font-weight:700;">Teachers / Accountant / Fee Staff</div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-yellow" href="staff_add.php">+ Add Staff</a>
        <a class="btn btn-white" href="staff_attendance.php">Attendance</a>
        <a class="btn btn-white" href="staff_salary.php">Salary</a>
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Staff List</h2>

        <form method="get" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;align-items:center;">
          <input class="input" type="text" name="q" value="<?php echo e($q); ?>" placeholder="Search name / code / designation">
          <button class="btn btn-blue" type="submit">Search</button>
          <a class="btn btn-white" href="staff_list.php">Reset</a>
        </form>

        <div style="height:12px"></div>

        <div style="overflow:auto">
          <table class="table">
            <thead>
              <tr>
                <th>ID</th>
                <th>Code</th>
                <th>Name</th>
                <th>Designation</th>
                <th>Phone</th>
                <th>Salary</th>
                <th>Status</th>
                <th style="min-width:160px;">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php if(!$rows): ?>
                <tr><td colspan="8" style="text-align:center;color:var(--muted);">No staff found.</td></tr>
              <?php else: foreach($rows as $r): ?>
                <tr>
                  <td><?php echo e($r['id']); ?></td>
                  <td><?php echo e($r['staff_code']); ?></td>
                  <td><?php echo e($r['full_name']); ?></td>
                  <td><?php echo e($r['designation']); ?></td>
                  <td><?php echo e($r['phone']); ?></td>
                  <td><?php echo e($r['monthly_salary']); ?></td>
                  <td><?php echo e($r['status']); ?></td>
                  <td>
                    <a class="btn btn-white btn-sm" href="staff_add.php?id=<?php echo (int)$r['id']; ?>">Edit</a>
                    <a class="btn btn-white btn-sm" href="staff_attendance.php?staff_id=<?php echo (int)$r['id']; ?>">Attendance</a>
                    <a class="btn btn-yellow btn-sm" href="staff_salary.php?staff_id=<?php echo (int)$r['id']; ?>">Salary</a>
                  </td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

        <p style="margin-top:10px;color:var(--muted);">
          Note: Run <b>db_upgrade_v7_staff.sql</b> in phpMyAdmin to create staff tables.
        </p>
      </div>
    </section>
  </main>
</div>
</body>
</html>
