<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) { header("Location: ../index.php"); exit(); }

$role = $_SESSION['role'] ?? 'user';
if (!in_array($role, ['admin','accountant'], true)) {
    http_response_code(403);
    die("Access denied.");
}

$pay_month = trim((string)($_GET['month'] ?? date('Y-m')));
$staff_id_filter = (int)($_GET['staff_id'] ?? 0);

function fetch_all(mysqli $conn, string $sql): array {
    $rows = [];
    if ($res = $conn->query($sql)) {
        while($r = $res->fetch_assoc()) $rows[] = $r;
        $res->free();
    }
    return $rows;
}

$staff = fetch_all($conn, "SELECT id, staff_code, full_name, designation, monthly_salary
                           FROM staff WHERE status='active' ORDER BY full_name ASC");

$existing = [];
$stmt = $conn->prepare("SELECT staff_id, basic_salary, allowances, deductions, net_pay, paid, paid_at
                        FROM staff_salary_payments WHERE pay_month=?");
if($stmt){
  $stmt->bind_param("s",$pay_month);
  $stmt->execute();
  $rows = stmt_fetch_all_assoc($stmt);
  foreach($rows as $r){
    $existing[(int)$r['staff_id']] = $r;
  }
  $stmt->close();
}

$msg=''; $err='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $pay_month = trim((string)($_POST['pay_month'] ?? date('Y-m')));
  $basic = $_POST['basic'] ?? [];
  $allow = $_POST['allow'] ?? [];
  $ded   = $_POST['ded'] ?? [];
  $paid  = $_POST['paid'] ?? [];

  $stmt = $conn->prepare("INSERT INTO staff_salary_payments
      (staff_id, pay_month, basic_salary, allowances, deductions, net_pay, paid, paid_at, paid_by, notes)
      VALUES (?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
        basic_salary=VALUES(basic_salary),
        allowances=VALUES(allowances),
        deductions=VALUES(deductions),
        net_pay=VALUES(net_pay),
        paid=VALUES(paid),
        paid_at=VALUES(paid_at),
        paid_by=VALUES(paid_by),
        notes=VALUES(notes)
  ");
  if(!$stmt){
    $err="DB error: ".$conn->error." (Run db_upgrade_v7_staff.sql)";
  } else {
    $paid_by = (int)($_SESSION['user_id'] ?? 0);
    $notes = '';
    foreach($staff as $s){
      $sid = (int)$s['id'];
      if($staff_id_filter>0 && $sid!==$staff_id_filter) continue;

      $b = isset($basic[$sid]) ? (float)$basic[$sid] : (float)$s['monthly_salary'];
      $a = isset($allow[$sid]) ? (float)$allow[$sid] : 0;
      $d = isset($ded[$sid]) ? (float)$ded[$sid] : 0;
      $net = ($b + $a) - $d;

      $isPaid = isset($paid[$sid]) ? 1 : 0;
      $paid_at = $isPaid ? date('Y-m-d') : null;

      $stmt->bind_param("issdddiisis", $sid, $pay_month, $b, $a, $d, $net, $isPaid, $paid_at, $paid_by, $notes);
      $stmt->execute();
    }
    $stmt->close();
    $msg="Salary saved for {$pay_month}";

    // reload existing
    $existing = [];
    $q = $conn->prepare("SELECT staff_id, basic_salary, allowances, deductions, net_pay, paid, paid_at
                         FROM staff_salary_payments WHERE pay_month=?");
    if($q){
      $q->bind_param("s",$pay_month);
      $q->execute();
      $rows = stmt_fetch_all_assoc($q);
      foreach($rows as $x){
        $existing[(int)$x['staff_id']] = $x;
      }
      $q->close();
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Staff Salary</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>
<div class="app">
  <aside class="sidebar">
    <div class="brand">
      <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
      <div class="brand-text">
        <div class="brand-title">The Foundation Montessori</div>
        <div class="brand-sub">School System</div>
      </div>
    </div>
    <nav class="nav">
      <a class="nav-link" href="../dashboard.php">Dashboard</a>
      <a class="nav-link" href="../students/student_list.php">Students</a>
      <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
      <a class="nav-link active" href="../staff/staff_list.php">Staff</a>
      <a class="nav-link" href="../fees/fees.php">Fees</a>
      <a class="nav-link" href="../exams/exams.php">Exams</a>
      <a class="nav-link" href="../reports/reports.php">Reports</a>
    </nav>
    <div class="sidebar-footer">
      <div class="small">Logged in as</div>
      <div class="strong"><?php echo e($_SESSION['user'] ?? 'User'); ?></div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;gap:10px;align-items:center;">
        <a class="btn btn-white" href="staff_list.php">Staff</a>
        <a class="btn btn-white" href="javascript:history.back()">Back</a>
      </div>
      <div style="text-align:center;flex:1;">
        <div class="topbar-title" style="font-size:18px;">Salary</div>
        <div style="margin-top:6px;font-weight:700;"><?php echo e($pay_month); ?></div>
      </div>
      <div style="display:flex;align-items:center;gap:10px;">
        <a class="btn btn-red" href="../logout.php">Log out</a>
      </div>
    </header>

    <section class="content">
      <div class="card">
        <h2 class="card-title">Monthly Salary</h2>

        <?php if($err): ?><div class="alert alert-danger"><?php echo e($err); ?></div><?php endif; ?>
        <?php if($msg): ?><div class="alert alert-success"><?php echo e($msg); ?></div><?php endif; ?>

        <form method="get" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;align-items:center;">
          <label class="label" style="margin:0;">Month</label>
          <input class="input" type="month" name="month" value="<?php echo e($pay_month); ?>">
          <button class="btn btn-blue" type="submit">Load</button>
          <a class="btn btn-white" href="staff_salary.php">This Month</a>
        </form>

        <div style="height:12px"></div>

        <form method="post">
          <input type="hidden" name="pay_month" value="<?php echo e($pay_month); ?>">

          <div style="overflow:auto">
            <table class="table">
              <thead>
                <tr>
                  <th>Name</th>
                  <th>Designation</th>
                  <th>Basic</th>
                  <th>Allowances</th>
                  <th>Deductions</th>
                  <th>Net</th>
                  <th>Paid</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach($staff as $s):
                $sid = (int)$s['id'];
                if($staff_id_filter>0 && $sid!==$staff_id_filter) continue;

                $ex = $existing[$sid] ?? null;
                $b = $ex ? (float)$ex['basic_salary'] : (float)$s['monthly_salary'];
                $a = $ex ? (float)$ex['allowances'] : 0;
                $d = $ex ? (float)$ex['deductions'] : 0;
                $net = ($b + $a) - $d;
                $isPaid = $ex ? (int)$ex['paid'] : 0;
              ?>
                <tr>
                  <td><?php echo e($s['full_name']); ?></td>
                  <td><?php echo e($s['designation']); ?></td>
                  <td><input class="input" type="number" step="0.01" name="basic[<?php echo $sid; ?>]" value="<?php echo e($b); ?>" style="max-width:140px;"></td>
                  <td><input class="input" type="number" step="0.01" name="allow[<?php echo $sid; ?>]" value="<?php echo e($a); ?>" style="max-width:140px;"></td>
                  <td><input class="input" type="number" step="0.01" name="ded[<?php echo $sid; ?>]" value="<?php echo e($d); ?>" style="max-width:140px;"></td>
                  <td style="font-weight:800;"><?php echo e(number_format($net,2)); ?></td>
                  <td style="text-align:center;">
                    <input type="checkbox" name="paid[<?php echo $sid; ?>]" <?php echo $isPaid? 'checked':''; ?>>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>

          <div style="margin-top:12px;display:flex;gap:10px;flex-wrap:wrap;">
            <button class="btn btn-blue" type="submit">Save Salary</button>
            <a class="btn btn-white" href="staff_list.php">Back</a>
          </div>

          <p style="margin-top:10px;color:var(--muted);">
            Notes: Allowances (e.g. transport) and deductions (e.g. late fine) are optional.
          </p>
        </form>
      </div>
    </section>
  </main>
</div>
</body>
</html>
