<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ID Card</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
    <div class="brand-text">
      <div class="brand-title">The Foundation Montessori</div>
      <div class="brand-sub">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link" href="../dashboard.php">Dashboard</a>
    <a class="nav-link" href="../students/student_list.php">Students</a>
    <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="../staff/staff_list.php">Staff</a>
    <a class="nav-link" href="../fees/fees.php">Fees</a>
    <a class="nav-link" href="../exams/exams.php">Exams</a>
    <a class="nav-link" href="../reports/reports.php">Reports</a>
  </div>
</div>

<div class="content">

<div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
  <div style="display:flex;gap:10px;align-items:center;">
    <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
    <a class="btn btn-white" href="javascript:history.back()">Back</a>
  </div>

  <div style="text-align:center;flex:1;">
    <div class="topbar-title" style="font-size:18px;">The Foundation Montessori</div>
    <div style="margin-top:6px;font-weight:700;"><?php echo htmlspecialchars($_SESSION['user'] ?? 'User'); ?></div>
  </div>

  <div style="display:flex;align-items:center;gap:10px;">
    <a class="btn btn-red" href="../logout.php">Log out</a>
  </div>
</div>

<div style="height:14px"></div>
<div class="card">

<h2 class="card-title">Student ID Card</h2>
<?php
$raw = $_GET['id'] ?? '';
$isNumericId = (is_string($raw) && ctype_digit($raw));

$sql = "
  SELECT st.id,
         COALESCE(NULLIF(st.admission_no,''), st.student_id) AS admission_no,
         COALESCE(NULLIF(TRIM(CONCAT(IFNULL(st.first_name,''),' ',IFNULL(st.last_name,''))),''), st.name) AS full_name,
         c.name AS class_name,
         sc.name AS section_name,
         st.issue_date,
         st.photo
  FROM students st
  LEFT JOIN classes c ON c.id = st.class_id
  LEFT JOIN sections sc ON sc.id = st.section_id
  WHERE " . ($isNumericId ? "st.id = ?" : "st.admission_no = ? OR st.student_id = ?") . "
  LIMIT 1
";

$stmt = $conn->prepare($sql);
$r = null;

if ($stmt) {
  if ($isNumericId) {
    $idVal = (int)$raw;
    $stmt->bind_param("i", $idVal);
  } else {
    $idVal = (string)$raw;
    $stmt->bind_param("ss", $idVal, $idVal);
  }

  $stmt->execute();
  $stmt->bind_result($id, $admission_no, $full_name, $class_name, $section_name, $issue_date, $photo);

  if ($stmt->fetch()) {
    $r = compact('id','admission_no','full_name','class_name','section_name','issue_date','photo');
  }
  $stmt->close();
}

if(!$r){
  echo "<p>Student not found.</p>";
} else {
  $issue = $r['issue_date'] ?? date('Y-m-d');
  $photo = $r['photo'] ?? '';
  $photo_url = $photo ? '../' . $photo : '';

  echo '<div class="card" style="max-width:420px;margin:0 auto;">';
  echo '<div style="display:flex;gap:12px;align-items:center;">';
  if($photo_url && file_exists(__DIR__ . '/../' . str_replace('../','',$photo))){
    echo '<img src="'.htmlspecialchars($photo_url).'" alt="photo" style="width:90px;height:90px;border-radius:16px;object-fit:cover;border:3px solid var(--yellow);">';
  } else {
    echo '<div style="width:90px;height:90px;border-radius:16px;background:#e5e7eb;"></div>';
  }
  echo '<div>';
  echo '<div style="font-size:18px;font-weight:800;">'.htmlspecialchars($r['full_name']).'</div>';
  echo '<div style="margin-top:6px;font-weight:800;">Admission No: '.htmlspecialchars($r['admission_no'] ?? '').'</div>';
  echo '<div style="color:var(--muted);font-weight:700;">Class: '.htmlspecialchars($r['class_name'] ?? '').' | Sec: '.htmlspecialchars($r['section_name'] ?? '').'</div>';
  echo '<div style="margin-top:8px;font-weight:700;">Issue Date: '.htmlspecialchars($issue).'</div>';
  echo '</div>';
  echo '</div>';
  echo '<div style="margin-top:14px;display:flex;gap:10px;justify-content:center;">';
  echo '<a class="btn btn-blue" href="?id='.htmlspecialchars((string)$raw).'&print=1">Auto Print</a>';
  echo '<a class="btn btn-white" href="student_list.php">Back</a>';
  echo '</div>';
  echo '</div>';
}

if(isset($_GET['print']) && $_GET['print']=='1'){ echo "<script>window.print();</script>"; }
?>

</div>
</div>
</body>
</html>