<?php
include '../config/config.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Students</title>
  <link rel="stylesheet" href="../assets/css/style.css?v=<?php echo APP_VERSION; ?>">
</head>
<body>

<div class="sidebar">
  <div class="brand">
    <div class="brand-logo"><img src="../assets/img/logo.svg" alt="Logo"></div>
    <div class=\"brand-text\">
      <div class=\"brand-title\">The Foundation Montessori</div>
      <div class=\"brand-sub\">School System</div>
    </div>
  </div>

  <div class="nav">
    <a class="nav-link" href="../dashboard.php">Dashboard</a>
    <a class="nav-link active" href="../students/student_list.php">Students</a>
    <a class="nav-link" href="../attendance/attendance.php">Attendance</a>
    <a class="nav-link" href="../staff/staff_list.php">Staff</a>
    <a class="nav-link" href="../fees/fees.php">Fees</a>
    <a class="nav-link" href="../exams/exams.php">Exams</a>
    <a class="nav-link" href="../reports/reports.php">Reports</a>
  </div>
</div>

<div class="content">

<div class="topbar" style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
  <div style="display:flex;gap:10px;align-items:center;">
    <a class="btn btn-white" href="../dashboard.php">Dashboard</a>
    <a class="btn btn-white" href="javascript:history.back()">Back</a>
  </div>

  <div style="text-align:center;flex:1;">
    <div class="topbar-title" style="font-size:18px;">The Foundation Montessori</div>
    <div style="margin-top:6px;font-weight:700;">Students — <?php echo htmlspecialchars($_SESSION['user'] ?? 'User'); ?></div>
  </div>

  <div style="display:flex;align-items:center;gap:10px;">
    <a class="btn btn-red" href="../logout.php">Log out</a>
  </div>
</div>

<div style="height:14px"></div>
<div class="card">

<h2 class="card-title">Student List</h2>
<div style="margin-bottom:12px;display:flex;gap:10px;flex-wrap:wrap;">
  <a class="btn btn-blue" href="add_student.php">Add Student</a>
  <a class="btn btn-white" href="?print=1">Auto Print</a>
</div>

<?php
$sql = "
  SELECT st.id,
         COALESCE(NULLIF(st.admission_no,''), st.student_id) AS admission_no,
         st.first_name, st.last_name, st.name,
         COALESCE(g.father_name, st.father_name) AS father_name,
         c.name AS class_name,
         sc.name AS section_name,
         se.title AS session_title
  FROM students st
  LEFT JOIN guardians g ON g.student_id = st.id
  LEFT JOIN classes c ON c.id = st.class_id
  LEFT JOIN sections sc ON sc.id = st.section_id
  LEFT JOIN sessions se ON se.id = st.session_id
  ORDER BY st.id DESC
";
$res = $conn->query($sql);
if(!$res){
  echo '<div class="alert">Database error: '.htmlspecialchars($conn->error).'</div>';
  $res = false;
}

echo '<table style="width:100%;border-collapse:collapse;">';
echo '<tr>
<th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Admission No</th>
<th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Name</th>
<th style="text-align:left;padding:8px;border-bottom:1px solid #e5e7eb;">Father</th>
<th style="padding:8px;border-bottom:1px solid #e5e7eb;">Class</th>
<th style="padding:8px;border-bottom:1px solid #e5e7eb;">Section</th>
<th style="padding:8px;border-bottom:1px solid #e5e7eb;">Session</th>
<th style="padding:8px;border-bottom:1px solid #e5e7eb;">ID Card</th>
</tr>';
if($res){ while($r = $res->fetch_assoc()){
  $displayName = trim(($r['first_name'] ?? '').' '.($r['last_name'] ?? ''));
  if($displayName === '') $displayName = $r['name'] ?? '';
  echo '<tr>';
  echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($r['admission_no'] ?? '').'</td>';
  echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($displayName).'</td>';
  echo '<td style="padding:8px;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($r['father_name'] ?? '').'</td>';
  echo '<td style="padding:8px;text-align:center;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($r['class_name'] ?? '').'</td>';
  echo '<td style="padding:8px;text-align:center;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($r['section_name'] ?? '').'</td>';
  echo '<td style="padding:8px;text-align:center;border-bottom:1px solid #f1f5f9;">'.htmlspecialchars($r['session_title'] ?? '').'</td>';
  echo '<td style="padding:8px;text-align:center;border-bottom:1px solid #f1f5f9;"><a class="btn btn-yellow" href="id_card.php?id='.htmlspecialchars($r['id']).'">Print</a></td>';
  echo '</tr>';
}}
echo '</table>';

if(isset($_GET['print']) && $_GET['print']=='1'){ echo "<script>window.print();</script>"; }
?>

</div>
</div>
</body>
</html>